/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.UpdateAction;
import com.ibm.ba.vis.vgs.gallery.cache.BundleCache;
import com.ibm.ba.vis.vgs.gallery.cache.CacheManager;
import com.ibm.ba.vis.vgs.gallery.cache.LocalCacheManager;
import com.ibm.ba.vis.vgs.gallery.fs.FileGalleryManager;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class CachedGalleryManager
extends FileGalleryManager {
    private final CacheManager cacheManager;
    private final VGSConfiguration config;

    public CachedGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory) {
        this(definitionManager, resourceFactory, LocalCacheManager.getInstance(), BundleCache.getInstance(), VGSConfiguration.getInstance());
    }

    CachedGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory, CacheManager cacheManager, BundleCache bundleCache, VGSConfiguration config) {
        super(definitionManager, resourceFactory, bundleCache);
        this.cacheManager = cacheManager;
        this.config = config;
    }

    @Override
    File getBundleDir(String visId) {
        try {
            return this.cacheManager.get(visId);
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
    }

    @Override
    List<File> listBundles(int startIndex, int pageSize) {
        try {
            return this.cacheManager.list(startIndex, pageSize);
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.failedToAccessLocalCache, (Throwable)e);
        }
    }

    @Override
    String getLocalETag(String visId) {
        return this.cacheManager.getETag(visId);
    }

    @Override
    public String store(Passport passport, InputStream bundleStream, UpdateAction updateAction) {
        String bundleTempName = UUID.randomUUID().toString().replaceAll("[-]", "");
        try {
            this.cacheManager.store(bundleTempName, "temp_version", bundleStream);
            String string = bundleTempName;
            return string;
        }
        catch (GalleryServiceException gse) {
            this.cacheManager.removeQuietly(bundleTempName);
            throw gse;
        }
        catch (IOException e) {
            this.cacheManager.removeQuietly(bundleTempName);
            throw new GalleryServiceException(GalleryAPIErrorCode.invalidBundleFormat, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bundleStream);
        }
    }

    @Override
    File getCompressedBundleFile(String visId) {
        String version = this.cacheManager.getETag(visId).replace('=', '.');
        String fileName = visId + "_" + version + ".zip";
        return new File(this.getCacheFolder(), fileName);
    }

    private File getCacheFolder() {
        File cacheFolder = new File(this.config.getTempFolder(), "cache/.compressed");
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
        return cacheFolder;
    }
}

