/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DataSetInfo;
import com.ibm.ba.vis.vgs.bundle.I18NString;
import com.ibm.ba.vis.vgs.gallery.fs.BaseInfoBuilder;
import com.ibm.ba.vis.vgs.gallery.fs.InfoBuilder;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import java.util.List;
import org.dom4j.Node;

public class ChartDefinitionInfoBuilder
extends BaseInfoBuilder {
    private final Node root;

    public ChartDefinitionInfoBuilder(ResourceManager resources, Node root) {
        super(resources);
        this.root = root;
    }

    @Override
    public String getId() {
        return this.getAttributeValue(this.root, "name");
    }

    @Override
    public String getAdapter() {
        return this.getAttributeValue(this.root, "adapter");
    }

    @Override
    public String getOutputType() {
        return "all";
    }

    @Override
    public I18NString getName() {
        return this.getI18NString(this.root, "/chartTypeDefinition/*[local-name()='label']");
    }

    @Override
    public I18NString getDescription() {
        return this.getI18NString(this.root, "/chartTypeDefinition/*[local-name()='description']");
    }

    @Override
    public I18NString getTooltip() {
        return this.getI18NString(this.root, "/chartTypeDefinition/*[local-name()='tooltip']");
    }

    @Override
    public String getAuthor() {
        return this.getElementValue(this.root, "/chartTypeDefinition/*[local-name()='author']");
    }

    @Override
    public List<I18NString> getTags() {
        String tagsXpath = "/chartTypeDefinition/*[local-name()='tags']/*[local-name()='tag']";
        List<Node> tagNodes = this.selectNodes(this.root, tagsXpath);
        return this.getTags(tagNodes);
    }

    @Override
    public List<DataSetInfo> getDataSetInfo() {
        String dataSetsXpath = "/chartTypeDefinition/*[local-name()='dataSets']/*[local-name()='dataSet']";
        List<Node> dataSetNodes = this.selectNodes(this.root, dataSetsXpath);
        return this.getDataSetInfo(dataSetNodes, new InfoBuilder.MetaInfoBuilder<DataSetInfo>(){

            @Override
            public DataSetInfo build(Node node) {
                int valueFieldsCount = ChartDefinitionInfoBuilder.this.selectNodes(node, ".//*[local-name()='valueField']").size();
                int categoryFieldsCount = ChartDefinitionInfoBuilder.this.selectNodes(node, ".//*[local-name()='categoryField']").size();
                I18NString resource = ChartDefinitionInfoBuilder.this.getI18NString(node, "./*[local-name()='label']");
                return new DataSetInfo(resource, categoryFieldsCount, valueFieldsCount);
            }
        });
    }
}

