/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.GalleryManager;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.cache.BundleCache;
import com.ibm.ba.vis.vgs.gallery.cache.CompressionUtil;
import com.ibm.ba.vis.vgs.gallery.cache.LockManager;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.ba.vis.vgs.gallery.fs.BundleFactory;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import com.ibm.cognos.rs.core.Status;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;

abstract class FileGalleryManager
implements GalleryManager {
    static final String COMPRESSED_BUNDLES_FOLDER = "cache/.compressed";
    static final String IMAGES_FOLDER = "images/";
    private final BundleCache bundleCache;
    private final BundleFactory bundleFactory;
    private final LockManager lockManager;

    FileGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory, BundleCache bundleCache) {
        this(new BundleFactory(definitionManager, resourceFactory), bundleCache);
    }

    FileGalleryManager(BundleFactory bundleFactory, BundleCache bundleCache) {
        this(bundleFactory, bundleCache, new LockManager());
    }

    FileGalleryManager(BundleFactory bundleFactory, BundleCache bundleCache, LockManager lockManager) {
        this.bundleFactory = bundleFactory;
        this.bundleCache = bundleCache;
        this.lockManager = lockManager;
    }

    @Override
    public ResultPage<VisBundle> list(Passport passport, int startIndex, int pageSize, String language, boolean custom) {
        List<File> bundleDirs = this.listBundles(startIndex, pageSize + 1);
        ResultPage<VisBundle> bundles = new ResultPage<VisBundle>(pageSize, startIndex, false);
        for (File directory : bundleDirs) {
            if (!directory.isDirectory()) continue;
            VisBundle bundle = this.loadBundle(directory);
            bundles.add(bundle);
        }
        return bundles;
    }

    @Override
    public VisBundle get(Passport passport, String visId, String lang) {
        try {
            String localEtag = this.getLocalETag(visId);
            VisBundle bundle = this.bundleCache.get(visId, localEtag);
            if (bundle == null) {
                File bundleDir = this.getBundleDir(visId);
                bundle = this.loadBundle(bundleDir);
                bundle.setVersion(localEtag);
                bundle.setStoreId(visId);
                File compressedBundle = this.getCompressedBundle(visId);
                bundle.setContentURI(compressedBundle.toURI());
                this.bundleCache.put(bundle, localEtag);
            }
            return bundle;
        }
        catch (GalleryServiceException gse) {
            if (Status.NOT_FOUND.equals((Object)gse.getStatus())) {
                ErrorMessage errorMsg = new ErrorMessage(GalleryAPIErrorCode.requestedBundleNotFound);
                errorMsg.addParameter("bundleId", visId);
                gse.addError(errorMsg);
            }
            throw gse;
        }
    }

    abstract File getCompressedBundleFile(String var1);

    private File getCompressedBundle(String visId) {
        File compressedBundle = this.getCompressedBundleFile(visId);
        try {
            if (!this.contentExists(visId, compressedBundle)) {
                this.compressBundleContent(visId, compressedBundle);
            }
        }
        catch (IOException e) {
            throw new GalleryServiceException(GalleryServiceErrorCode.internalServiceError, (Throwable)e);
        }
        return compressedBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contentExists(String visId, File compressedBundle) {
        Lock readLock = this.lockManager.getReadLock(visId);
        try {
            readLock.lock();
            boolean bl = compressedBundle.exists();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressBundleContent(String visId, File compressedBundle) throws IOException {
        Lock writeLock = this.lockManager.getWriteLock(visId);
        try {
            writeLock.lock();
            if (!compressedBundle.exists()) {
                CompressionUtil.compress(this.getBundleDir(visId), compressedBundle);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    VisBundle loadBundle(File bundleDir) {
        return this.bundleFactory.create(bundleDir);
    }

    abstract String getLocalETag(String var1);

    abstract File getBundleDir(String var1);

    abstract List<File> listBundles(int var1, int var2);
}

