/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.UpdateAction;
import com.ibm.ba.vis.vgs.gallery.cache.BundleCache;
import com.ibm.ba.vis.vgs.gallery.cache.CompressionUtil;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.ba.vis.vgs.gallery.fs.FileGalleryManager;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileSystemGalleryManager
extends FileGalleryManager {
    private static final String BUNDLE_DIR = System.getProperty("com.ibm.ba.vis.vgs.bundledir", "../webapps/p2pd/WEB-INF/visBundles");
    private final File galleryRoot;

    public FileSystemGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory) {
        this(definitionManager, resourceFactory, BundleCache.getInstance(), BUNDLE_DIR);
    }

    FileSystemGalleryManager(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory, BundleCache bundleCache, String bundleDir) {
        super(definitionManager, resourceFactory, bundleCache);
        this.galleryRoot = new File(bundleDir);
    }

    @Override
    File getBundleDir(String visId) {
        return new File(this.galleryRoot, visId);
    }

    @Override
    List<File> listBundles(int startIndex, int pageSize) {
        File root = this.galleryRoot;
        ResultPage<File> bundleList = new ResultPage<File>(pageSize, startIndex);
        Object[] bundles = root.listFiles(BundleFileFilter.INSTANCE);
        Arrays.sort(bundles);
        if (bundles != null) {
            for (Object bundle : bundles) {
                if (!bundleList.add((File)bundle)) break;
            }
        }
        return bundleList;
    }

    @Override
    public String store(Passport passport, InputStream bundleStream, UpdateAction updateAction) {
        String bundleTempName = UUID.randomUUID().toString().replaceAll("[-]", "");
        File bundleDir = this.getBundleDir(bundleTempName);
        bundleDir.mkdir();
        try {
            ZipInputStream compressedStream = bundleStream instanceof ZipInputStream ? (ZipInputStream)bundleStream : new ZipInputStream(bundleStream);
            CompressionUtil.uncompress(compressedStream, bundleDir);
            VisBundle visBundle = this.loadBundle(bundleDir);
            String bundleID = visBundle.getId();
            File existingBundle = this.getBundleDir(bundleID);
            switch (updateAction) {
                case FAIL: {
                    if (!existingBundle.exists()) break;
                    ErrorMessage message = new ErrorMessage(GalleryAPIErrorCode.bundleAlreadyExists);
                    message.addParameter("bundleId", bundleID);
                    throw new GalleryServiceException(message);
                }
            }
            FileUtils.deleteQuietly((File)existingBundle);
            bundleDir.renameTo(existingBundle);
            String string = bundleID;
            return string;
        }
        catch (GalleryServiceException gse) {
            FileUtils.deleteQuietly((File)bundleDir);
            gse.addError(GalleryAPIErrorCode.invalidBundleFormat);
            throw gse;
        }
        catch (IOException e) {
            FileUtils.deleteQuietly((File)bundleDir);
            throw new GalleryServiceException(GalleryAPIErrorCode.invalidBundleFormat, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bundleStream);
        }
    }

    @Override
    String getLocalETag(String visId) {
        File bundleDir = this.getBundleDir(visId);
        long lastModified = bundleDir.lastModified();
        return Long.toHexString(lastModified);
    }

    @Override
    File getCompressedBundleFile(String visId) {
        String fileName = visId + ".zip";
        File compressedBundlesDir = this.getCompressedBundlesDir();
        return new File(compressedBundlesDir, fileName);
    }

    private File getCompressedBundlesDir() {
        File compressedbundlesDir = new File(this.galleryRoot, ".cache/.compressed");
        if (!compressedbundlesDir.exists()) {
            compressedbundlesDir.mkdirs();
        }
        return compressedbundlesDir;
    }

    private static class BundleFileFilter
    implements FileFilter {
        private static final BundleFileFilter INSTANCE = new BundleFileFilter();

        private BundleFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return !file.getName().startsWith(".");
            }
            return false;
        }
    }
}

