/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.Image;
import com.ibm.ba.vis.vgs.bundle.MimeMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class FileSystemImage
implements Image {
    private File file;
    private String name;
    private String size;
    private String type;
    private String relType;

    public void load(File imageFile) {
        this.file = imageFile;
        this.name = FilenameUtils.getName((String)this.file.getName());
        this.type = FilenameUtils.getExtension((String)this.name);
        String basename = FilenameUtils.getBaseName((String)this.name);
        String[] parts = StringUtils.split((String)basename, (String)"_");
        this.relType = parts[0];
        this.size = parts.length > 1 ? parts[1] : null;
    }

    @Override
    public InputStream getImage() throws IOException {
        return FileUtils.openInputStream((File)this.file);
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getMimeType() {
        return MimeMap.get(this.type);
    }

    @Override
    public String getRelType() {
        return this.relType;
    }

    public String toString() {
        return this.getName();
    }
}

