/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.fs;

import com.ibm.ba.vis.vgs.bundle.DataSetInfo;
import com.ibm.ba.vis.vgs.bundle.DefinitionManager;
import com.ibm.ba.vis.vgs.bundle.I18NString;
import com.ibm.ba.vis.vgs.bundle.Image;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.error.ErrorMessage;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.cache.CompressionUtil;
import com.ibm.ba.vis.vgs.gallery.fs.BaseInfoBuilder;
import com.ibm.ba.vis.vgs.gallery.fs.ChartDefinitionInfoBuilder;
import com.ibm.ba.vis.vgs.gallery.fs.FileSystemImage;
import com.ibm.ba.vis.vgs.gallery.fs.MsgPropertiesFilter;
import com.ibm.ba.vis.vgs.gallery.fs.VisualizationDefinitionInfoBuilder;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import com.ibm.ba.vis.vgs.resources.ResourceManagerFactory;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class FileSystemVisBundle
implements VisBundle {
    private static final String ZIP_FORMAT = "zip";
    private static final String JSON_FORMAT = "json";
    static final String DEFAULT_LANG = "en";
    private static final Pattern LANG_PROP_PATTERN = Pattern.compile("(?:[_](?:(([a-zA-Z]{2}[_]?){1,2}(?:_\\w*)?)))[.]properties$");
    private static final List<String> DEFAULT_FORMATS = Arrays.asList("json", "zip");
    private final ResourceManagerFactory resourceFactory;
    private final DefinitionManager definitionManager;
    private final File bundleDirectory;
    private List<I18NString> tags;
    private List<DataSetInfo> datasetInfoList;
    private String bundleId;
    private String bundleType;
    private String bundleIcon;
    private String storeId;
    private I18NString nameResource;
    private I18NString descriptionResource;
    private I18NString tooltipResource;
    private String author;
    private String adapter;
    private String version;
    private URI contentURI;
    private Date lastUpdated;
    private String lastUpdatedAsString;
    private String outputType;
    private boolean customViz = false;
    private String tenant;
    private ResourceManager resourceManager;

    public FileSystemVisBundle(DefinitionManager definitionManager, ResourceManagerFactory resourceFactory, File bundleDirectory) {
        this.definitionManager = definitionManager;
        this.resourceFactory = resourceFactory;
        this.bundleDirectory = bundleDirectory;
        this.contentURI = URI.create("");
    }

    @Override
    public String getName(String language) {
        return this.nameResource != null ? this.nameResource.getValue(language) : null;
    }

    public void setName(String name) {
        this.nameResource = new I18NString(null, null, name);
    }

    @Override
    public String getDescription(String language) {
        return this.descriptionResource != null ? this.descriptionResource.getValue(language) : null;
    }

    public void setDescription(String description) {
        this.descriptionResource = new I18NString(null, null, description);
    }

    @Override
    public String getTooltip(String language) {
        String tooltip = this.tooltipResource.getValue(language);
        if (StringUtils.isBlank((String)tooltip)) {
            tooltip = this.getDescription(language);
        }
        return tooltip;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    @Override
    public List<I18NString> getTags() {
        return this.tags;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public InputStream getDefinition(String language, String definitionVersion) throws IOException {
        InputStream definitionStream = null;
        try {
            definitionStream = this.getDefinitionStream();
            InputStream inputStream = this.definitionManager.upgradeAndTranslate(definitionStream, definitionVersion, language, this.resourceManager);
            return inputStream;
        }
        catch (UnsupportedOperationException e) {
            ErrorMessage message = new ErrorMessage(GalleryAPIErrorCode.unsupportedUpgrade);
            message.addParameter("definitionVersion", definitionVersion);
            throw new GalleryServiceException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)definitionStream);
        }
    }

    @Override
    public InputStream getDefinition(String language, String definitionVersion, String element) throws IOException {
        InputStream definitionStream = null;
        try {
            definitionStream = this.getDefinitionStream();
            InputStream inputStream = this.definitionManager.upgradeAndTranslate(definitionStream, definitionVersion, language, this.resourceManager, element);
            return inputStream;
        }
        catch (UnsupportedOperationException e) {
            ErrorMessage message = new ErrorMessage(GalleryAPIErrorCode.unsupportedUpgrade);
            message.addParameter("definitionVersion", definitionVersion);
            throw new GalleryServiceException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)definitionStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getImplementation(String format) throws IOException {
        FileInputStream implIs = null;
        try {
            File implementation = new File(this.bundleDirectory, "implementation.json");
            if (ZIP_FORMAT.equals(format)) {
                File compressedImplementation = new File(this.bundleDirectory, "implementation.zip");
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    if (!compressedImplementation.exists()) {
                        this.compressImplementation(implementation, compressedImplementation);
                    }
                }
                implIs = FileUtils.openInputStream((File)compressedImplementation);
            } else {
                implIs = FileUtils.openInputStream((File)implementation);
            }
            return implIs;
        }
        catch (IOException e) {
            IOUtils.closeQuietly(implIs);
            throw e;
        }
    }

    private void compressImplementation(File jsonSrcFile, File compressedDestFile) throws IOException {
        if (!compressedDestFile.exists()) {
            CompressionUtil.compress(jsonSrcFile, compressedDestFile);
        }
    }

    @Override
    public List<String> getImplementationFormats() {
        return DEFAULT_FORMATS;
    }

    @Override
    public List<Image> getImages() {
        return this.getImages(null);
    }

    @Override
    public List<Image> getImages(String relType) {
        File imageDir = new File(this.bundleDirectory, "images");
        File[] imageFiles = imageDir.listFiles();
        List<Image> images = Collections.emptyList();
        if (imageFiles != null) {
            images = new ArrayList<Image>(imageFiles.length);
            for (File file : imageFiles) {
                FileSystemImage image = new FileSystemImage();
                image.load(file);
                if (relType != null && !relType.equals(image.getRelType())) continue;
                images.add(image);
            }
        }
        return images;
    }

    @Override
    public Image getImage(String imageId) {
        FileSystemImage image = null;
        File imageDir = new File(this.bundleDirectory, "images");
        File imageFile = new File(imageDir, imageId);
        if (imageFile.exists()) {
            image = new FileSystemImage();
            image.load(imageFile);
        }
        return image;
    }

    @Override
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public String getLastUpdatedAsString() {
        return this.lastUpdatedAsString;
    }

    @Override
    public void setLastUpdated(Date lastUpdated) {
        if (lastUpdated != null) {
            this.lastUpdated = lastUpdated;
        }
    }

    @Override
    public void setLastUpdatedAsString(String lastUpdatedAsString) {
        this.lastUpdatedAsString = lastUpdatedAsString;
    }

    @Override
    public String getId() {
        return this.bundleId;
    }

    @Override
    public String getType() {
        return this.bundleType;
    }

    @Override
    public String getIcon() {
        return this.bundleIcon;
    }

    @Override
    public String getStoreId() {
        return this.storeId;
    }

    @Override
    public String getAdapter() {
        return this.adapter;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    @Override
    public URI getContentURI() {
        return this.contentURI;
    }

    @Override
    public void setContentURI(URI contentURI) {
        if (contentURI != null) {
            this.contentURI = contentURI;
        }
    }

    @Override
    public List<DataSetInfo> getDataSetInfoList() {
        return this.datasetInfoList;
    }

    @Override
    public Set<String> getLanguages() {
        if (this.customViz) {
            HashSet<String> langList = new HashSet<String>();
            langList.add(DEFAULT_LANG);
            return langList;
        }
        File resourceDir = new File(this.bundleDirectory, "resources");
        String[] propsFileNames = resourceDir.list(MsgPropertiesFilter.INSTANCE);
        Set<String> langList = propsFileNames != null && propsFileNames.length > 0 ? this.extractLangList(propsFileNames) : Collections.emptySet();
        return langList;
    }

    @Override
    public boolean isCustomViz() {
        return this.customViz;
    }

    public void load() {
        this.setLastUpdated(new Date(this.bundleDirectory.lastModified()));
        this.readDetails();
    }

    private Set<String> extractLangList(String[] propsFileNames) {
        HashSet<String> langList = new HashSet<String>(propsFileNames.length + 1);
        for (String fileName : propsFileNames) {
            Matcher matcher = LANG_PROP_PATTERN.matcher(fileName);
            if (matcher.find()) {
                String lang = matcher.group(1);
                if (lang == null) continue;
                langList.add(lang);
                continue;
            }
            langList.add(DEFAULT_LANG);
        }
        if (langList.isEmpty()) {
            langList.add(DEFAULT_LANG);
        }
        return langList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readDetails() {
        SAXReader reader;
        InputStream metaStream;
        InputStream definitionStream;
        block10: {
            definitionStream = null;
            metaStream = null;
            reader = new SAXReader();
            metaStream = this.getBundleFileStream("meta.json");
            if (metaStream == null) break block10;
            this.readDetailsCustomBundle(metaStream, reader);
            IOUtils.closeQuietly(definitionStream);
            IOUtils.closeQuietly((InputStream)metaStream);
            return;
        }
        try {
            this.definitionManager.validate(this);
            definitionStream = this.getDefinitionStream();
            Document doc = reader.read(definitionStream);
            Element root = doc.getRootElement();
            this.prepareResourceManager();
            BaseInfoBuilder builder = null;
            if ("chartTypeDefinition".equalsIgnoreCase(root.getName())) {
                builder = new ChartDefinitionInfoBuilder(this.resourceManager, (Node)root);
            } else {
                builder = new VisualizationDefinitionInfoBuilder(this.resourceManager, (Node)root);
                Attribute isValid = (Attribute)root.selectSingleNode("@isValid");
                if (isValid != null && isValid.getValue().equalsIgnoreCase("false")) {
                    throw new GalleryServiceException(GalleryAPIErrorCode.invalidVisCustomizerBundle);
                }
            }
            String id = builder.getId();
            if (!id.isEmpty()) {
                this.validateId(id);
            }
            this.bundleId = id;
            this.adapter = builder.getAdapter();
            this.nameResource = builder.getName();
            this.descriptionResource = builder.getDescription();
            this.tooltipResource = builder.getTooltip();
            this.author = builder.getAuthor();
            this.tags = builder.getTags();
            this.datasetInfoList = builder.getDataSetInfo();
            this.outputType = builder.getOutputType();
        }
        catch (GalleryServiceException gse) {
            try {
                gse.addError(GalleryAPIErrorCode.unableToLoadBundle);
                throw gse;
                catch (Exception e) {
                    throw new GalleryServiceException(GalleryAPIErrorCode.unableToLoadBundle, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(definitionStream);
                IOUtils.closeQuietly(metaStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)definitionStream);
        IOUtils.closeQuietly((InputStream)metaStream);
        return;
    }

    private void readDetailsCustomBundle(InputStream metaStream, SAXReader reader) throws IOException, DocumentException {
        this.customViz = true;
        if (metaStream != null) {
            JSONObject obj = (JSONObject)JSON.parse((InputStream)metaStream);
            String name = (String)obj.get((Object)"name");
            this.bundleId = (String)obj.get((Object)"id");
            this.bundleType = (String)obj.get((Object)"type");
            if (this.isNullOrEmpty(name) || this.isNullOrEmpty(this.bundleId) || this.isNullOrEmpty(this.bundleType)) {
                throw new GalleryServiceException(GalleryAPIErrorCode.invalidBundleFormat);
            }
            this.nameResource = new I18NString(null, null, name);
            this.descriptionResource = new I18NString(null, null, (String)obj.get((Object)"description"));
            this.bundleIcon = (String)obj.get((Object)"icon");
            this.tooltipResource = this.nameResource;
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    private void prepareResourceManager() {
        File resourceDir = new File(this.bundleDirectory, "resources");
        this.resourceManager = this.resourceFactory.getResourceManager(resourceDir);
    }

    private void validateId(String id) {
        Matcher idMatcher = BUNDLE_ID_PATTERN.matcher(id);
        if (!idMatcher.matches()) {
            ErrorMessage errorMessage = new ErrorMessage(GalleryAPIErrorCode.invalidBundleId);
            errorMessage.addParameter("bundleId", id);
            throw new GalleryServiceException(errorMessage);
        }
    }

    public InputStream getDefinitionStream() throws IOException {
        File definition = new File(this.bundleDirectory, "definition.xml");
        if (!definition.exists()) {
            throw new GalleryServiceException(GalleryAPIErrorCode.missingBundleDefinition);
        }
        return FileUtils.openInputStream((File)definition);
    }

    public InputStream getBundleFileStream(String path) throws IOException {
        File bundleFile = new File(this.bundleDirectory, path);
        return bundleFile.exists() ? new BufferedInputStream(FileUtils.openInputStream((File)bundleFile)) : null;
    }

    public List<String> getBundleFiles() throws IOException {
        try (Stream<Path> dirStream = Files.walk(Paths.get(this.bundleDirectory.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
            List<String> list = dirStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(x -> x.toString().substring(this.bundleDirectory.getAbsolutePath().length() + 1)).collect(Collectors.toList());
            return list;
        }
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }
}

