/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.gallery.mem;

import com.ctc.wstx.stax.WstxEventFactory;
import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import com.ibm.ba.vis.schema.definition.Rave2BundleDefinitionManager;
import com.ibm.ba.vis.vgs.bundle.DataSetInfo;
import com.ibm.ba.vis.vgs.bundle.I18NString;
import com.ibm.ba.vis.vgs.bundle.Image;
import com.ibm.ba.vis.vgs.bundle.VisBundle;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.cache.ResultPage;
import com.ibm.ba.vis.vgs.gallery.fs.BaseInfoBuilder;
import com.ibm.ba.vis.vgs.gallery.fs.ChartDefinitionInfoBuilder;
import com.ibm.ba.vis.vgs.gallery.fs.VisualizationDefinitionInfoBuilder;
import com.ibm.ba.vis.vgs.parser.DefinitionParser;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import com.ibm.rave.bundles.nativeImpl.BundleLookup;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class InMemVisBundle
implements VisBundle {
    private static final String ZIP_FORMAT = "zip";
    private static final String JSON_FORMAT = "json";
    private static final List<String> DEFAULT_FORMATS = Arrays.asList("json", "zip");
    private List<I18NString> tags;
    private List<DataSetInfo> datasetInfoList;
    private String bundleName;
    private String lang;
    private I18NString nameResource;
    private I18NString descriptionResource;
    private I18NString tooltipResource;
    private String author;
    private String adapter;
    private String version = "version=1";
    private URI contentURI;
    private String outputType = "";
    private ResourceManager resourceManager;
    private DefinitionParser parser;

    public InMemVisBundle(String bundleName, String lang) {
        this.bundleName = bundleName;
        this.lang = lang;
        this.contentURI = URI.create("");
        WstxOutputFactory outputFactory = new WstxOutputFactory();
        WstxEventFactory eventFactory = new WstxEventFactory();
        this.parser = new DefinitionParser(InMemVisBundle.createXMLInputFactory(), (XMLOutputFactory)outputFactory, (XMLEventFactory)eventFactory);
    }

    public static void loadRave2BundlesInResultPage(ResultPage<VisBundle> bundles, String language, String category) {
        List bundleNames = BundleLookup.getBundleIds();
        for (String name : bundleNames) {
            List bundleConfigIDs = Rave2BundleDefinitionManager.getRave2BundleConfigIDs((String)name);
            block1: for (String configID : bundleConfigIDs) {
                VisBundle bundle = InMemVisBundle.loadRave2BundleFromMemory(name + "," + configID, language);
                if (category == null) {
                    bundles.add(bundle);
                    continue;
                }
                List<I18NString> tags = bundle.getTags();
                for (I18NString tag : tags) {
                    if (!tag.getValue(language).equals(category)) continue;
                    bundles.add(bundle);
                    continue block1;
                }
            }
        }
    }

    public static VisBundle loadRave2BundleFromMemory(String bundleNameWithConfigID, String language) {
        InMemVisBundle bundle = new InMemVisBundle(bundleNameWithConfigID, Rave2BundleDefinitionManager.updateLangName((String)language));
        bundle.load();
        return bundle;
    }

    private static XMLInputFactory createXMLInputFactory() {
        WstxInputFactory inputFactory = new WstxInputFactory();
        inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        inputFactory.setProperty("javax.xml.stream.resolver", new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                throw new XMLStreamException("Access to denied to publicID=" + publicID + ", systemID=" + systemID + ".");
            }
        });
        return inputFactory;
    }

    @Override
    public String getName(String language) {
        return this.nameResource.getValue(language);
    }

    @Override
    public String getDescription(String language) {
        return this.descriptionResource.getValue(language);
    }

    @Override
    public String getTooltip(String language) {
        String tooltip = this.tooltipResource.getValue(language);
        if (StringUtils.isBlank((String)tooltip)) {
            tooltip = this.getDescription(language);
        }
        return tooltip;
    }

    @Override
    public String getOutputType() {
        return this.outputType;
    }

    @Override
    public List<I18NString> getTags() {
        return this.tags;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public InputStream getDefinition(String lang, String definitionVersion) throws IOException {
        String definition = Rave2BundleDefinitionManager.getOneLangRave2OneBundleDefinition((String)this.bundleName, (String)lang);
        return IOUtils.toInputStream((String)definition, (String)"UTF-8");
    }

    public InputStream getDefinitionStream(String language) throws IOException {
        return this.getDefinition(language, "");
    }

    @Override
    public InputStream getImplementation(String format) throws IOException {
        return null;
    }

    @Override
    public List<String> getImplementationFormats() {
        return DEFAULT_FORMATS;
    }

    @Override
    public List<Image> getImages() {
        return null;
    }

    @Override
    public List<Image> getImages(String relType) {
        return null;
    }

    @Override
    public Image getImage(String imageId) {
        return null;
    }

    @Override
    public Date getLastUpdated() {
        return null;
    }

    @Override
    public void setLastUpdated(Date lastUpdated) {
    }

    @Override
    public String getId() {
        return this.bundleName;
    }

    @Override
    public String getAdapter() {
        return this.adapter;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public URI getContentURI() {
        return this.contentURI;
    }

    @Override
    public void setContentURI(URI contentURI) {
        if (contentURI != null) {
            this.contentURI = contentURI;
        }
    }

    @Override
    public List<DataSetInfo> getDataSetInfoList() {
        return this.datasetInfoList;
    }

    @Override
    public Set<String> getLanguages() {
        return new HashSet<String>(Arrays.asList(this.lang));
    }

    public void load() {
        this.setLastUpdated(new Date());
        this.readDetails();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readDetails() {
        InputStream definitionStream = null;
        try {
            definitionStream = this.getDefinitionStream(this.lang);
            SAXReader reader = new SAXReader();
            Document doc = reader.read(definitionStream);
            Element root = doc.getRootElement();
            BaseInfoBuilder builder = null;
            if ("chartTypeDefinition".equalsIgnoreCase(root.getName())) {
                builder = new ChartDefinitionInfoBuilder(this.resourceManager, (Node)root);
            } else {
                builder = new VisualizationDefinitionInfoBuilder(this.resourceManager, (Node)root);
                Attribute isValid = (Attribute)root.selectSingleNode("@isValid");
                if (isValid != null && isValid.getValue().equalsIgnoreCase("false")) {
                    throw new GalleryServiceException(GalleryAPIErrorCode.invalidVisCustomizerBundle);
                }
            }
            this.adapter = builder.getAdapter();
            this.nameResource = builder.getName();
            this.descriptionResource = builder.getDescription();
            this.tooltipResource = builder.getTooltip();
            this.author = builder.getAuthor();
            this.tags = builder.getTags();
            this.datasetInfoList = builder.getDataSetInfo();
            this.outputType = builder.getOutputType();
        }
        catch (GalleryServiceException gse) {
            try {
                gse.addError(GalleryAPIErrorCode.unableToLoadBundle);
                throw gse;
                catch (Exception e) {
                    throw new GalleryServiceException(GalleryAPIErrorCode.unableToLoadBundle, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(definitionStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)definitionStream);
    }

    @Override
    public InputStream getDefinition(String language, String definitionVersion, String element) throws IOException {
        InputStream inputStream;
        language = Rave2BundleDefinitionManager.updateLangName((String)language);
        ByteArrayInputStream definitionStream = null;
        try {
            String definition = Rave2BundleDefinitionManager.getOneLangRave2OneBundleDefinition((String)this.bundleName, (String)language);
            definitionStream = new ByteArrayInputStream(definition.getBytes("UTF-8"));
            inputStream = this.parser.parse(definitionStream, language, this.resourceManager, element);
        }
        catch (Exception e) {
            try {
                throw new GalleryServiceException(GalleryAPIErrorCode.unableToLoadBundle, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(definitionStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)definitionStream);
        return inputStream;
    }

    @Override
    public boolean isCustomViz() {
        return false;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public String getStoreId() {
        return null;
    }

    @Override
    public void setStoreId(String storeId) {
    }

    @Override
    public String getLastUpdatedAsString() {
        return null;
    }

    @Override
    public void setLastUpdatedAsString(String lastUpdated) {
    }
}

