/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.p2pd;

import com.cognos.ccl4j.bibus.CAMCookie;
import com.cognos.ccl4j.bibus.CAMCookieFactory;
import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.gallery.Passport;
import com.ibm.ba.vis.vgs.gallery.RequestContextHelper;
import com.ibm.ba.vis.vgs.p2pd.CamPassport;
import com.ibm.cognos.rs.core.RequestContext;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;

public class PogoContextHelper
implements RequestContextHelper {
    private static final String EMPTY_STRING = "";
    private static final String CAM_PASSPORT_COOKIE = "cam_passport";
    private static final String XSRF_TOKEN_COOKIE = "XSRF-TOKEN";
    private static final String XSRF_TOKEN_HEADER = "X-XSRF-TOKEN";
    private static final String COOKIE_HEADER = "cookie";
    private static final boolean xsrfCheckEnabled = !Boolean.getBoolean("disableXSRFCheck");

    @Override
    public Passport getPassport(RequestContext context) {
        String encodedValue = EMPTY_STRING;
        String value = EMPTY_STRING;
        encodedValue = this.getCookieValue(context, CAM_PASSPORT_COOKIE);
        if (!StringUtils.isNotEmpty((String)encodedValue)) {
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        }
        value = PogoContextHelper.getCAMPassportID(encodedValue);
        String cookies = context.getHeader(COOKIE_HEADER);
        String xsrfToken = context.getHeader(XSRF_TOKEN_HEADER);
        return new CamPassport(value, encodedValue, cookies, xsrfToken);
    }

    @Override
    public void validateXsrfToken(RequestContext context) {
        if (xsrfCheckEnabled) {
            String xsrfTokenCookieValue = this.getCookieValue(context, XSRF_TOKEN_COOKIE);
            if (StringUtils.isNotEmpty((String)xsrfTokenCookieValue) && xsrfTokenCookieValue.equals(context.getHeader(XSRF_TOKEN_HEADER))) {
                return;
            }
            throw new GalleryServiceException(GalleryAPIErrorCode.insufficientAccessRights);
        }
    }

    String getCookieValue(RequestContext context, String cookieName) {
        Cookie cookieValue = context.getCookie(cookieName);
        if (cookieValue != null) {
            return cookieValue.getValue();
        }
        return EMPTY_STRING;
    }

    private static String getCAMPassportID(String cookieValue) {
        CAMCookie aCookie = CAMCookieFactory.createCAMCookie((String)cookieValue);
        return aCookie.getPassportID();
    }
}

