/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.p2pd;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.ibm.ba.vis.vgs.VgsApplicationModule;
import com.ibm.ba.vis.vgs.config.VGSConfiguration;
import com.ibm.ba.vis.vgs.gallery.cache.CacheManager;
import com.ibm.ba.vis.vgs.gallery.cache.LocalCacheManager;
import com.ibm.ba.vis.vgs.p2pd.logging.LogKitLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.core.RequestHandler;
import com.ibm.cognos.rs.core.WebApplicationModule;
import com.ibm.cognos.rs.pogo.PogoRequestContextProvider;

public class VisualisationGalleryService
extends BasicHandler {
    private final WebApplicationModule module;
    private final VGSConfiguration vgsConfig;
    private final CacheManager cacheManager;
    private final PogoRequestContextProvider contextProvider;

    public VisualisationGalleryService() {
        this(VgsApplicationModule.getInstance(), PogoRequestContextProvider.getInstance(), VGSConfiguration.getInstance(), LocalCacheManager.getInstance());
        VgsApplicationModule.getInstance().setLog(new LogKitLogger(((Object)((Object)this)).getClass()));
    }

    VisualisationGalleryService(WebApplicationModule module, PogoRequestContextProvider contextProvider, VGSConfiguration vgsConfig, CacheManager cacheManager) {
        super(null);
        this.module = module;
        this.contextProvider = contextProvider;
        this.vgsConfig = vgsConfig;
        this.cacheManager = cacheManager;
        module.registerResources();
    }

    public void invokeImpl(MessageContext msgContext) throws PogoException {
        RequestHandler handler = this.module.getHandler();
        RequestContext context = this.contextProvider.provide(msgContext);
        ZipiTimer zipiTimer = ZipiFactory.getCurrentTimer();
        if (zipiTimer != ZipiTimer.NULL) {
            zipiTimer.setObjectPath(context.getRequestURI().getPath());
        }
        handler.handle(context);
    }

    public void configure(Configuration configuration) {
        System.setProperty("java.awt.headless", "true");
        System.setProperty("org.apache.abdera.writer.StreamWriter", "com.ibm.ba.vis.vgs.atom.WSTXStreamWriter");
        super.configure(configuration);
        this.vgsConfig.reconfigure(configuration);
    }

    public void reconfigure(Configuration configuration) {
        super.reconfigure(configuration);
        this.vgsConfig.reconfigure(configuration);
    }

    public void dispose() {
        super.dispose();
        this.cacheManager.clear();
    }
}

