/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.p2pd.logging;

import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogTypedLogger;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import com.ibm.ba.vis.vgs.p2pd.VisualisationGalleryService;
import java.util.Arrays;
import java.util.List;

public class GalleryServiceIPFLogging {
    static final String SERVICE_NAME = "VGS";
    private static int buildNumber = Integer.MIN_VALUE;
    private static final GalleryServiceIPFLogging INSTANCE = new GalleryServiceIPFLogging();
    private LogTypedLogger typedLogger;

    GalleryServiceIPFLogging() {
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isEnabled(50000);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isEnabled(40000);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isEnabled(30000);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isEnabled(20000);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isEnabled(10000);
    }

    public void warn(String errorMessage) {
        this.warn(Arrays.asList(errorMessage));
    }

    public void warn(String errorMessage, Throwable t) {
        this.warn(Arrays.asList(errorMessage, t.getLocalizedMessage()));
    }

    public void warn(String errorMessage, GalleryServiceException gse) {
        this.warn(gse.getAllMessages());
    }

    private void warn(List<String> errorMessages) {
        if (this.isWarnEnabled()) {
            this.log(30000, "Warning", errorMessages);
        }
    }

    public void error(String errorMessage) {
        this.error(Arrays.asList(errorMessage));
    }

    public void error(String errorMessage, Throwable t) {
        this.error(Arrays.asList(errorMessage, t.getLocalizedMessage()));
    }

    public void error(String errorMessage, GalleryServiceException gse) {
        this.error(gse.getAllMessages());
    }

    private void error(List<String> errorMessages) {
        if (this.isErrorEnabled()) {
            this.log(40000, "Failure", errorMessages);
        }
    }

    private void log(int level, String status, List<String> errorMessages) {
        LogAuditAccessIndication indication = new LogAuditAccessIndication(SERVICE_NAME, this.getBuildNumber());
        indication.setLevel(level);
        indication.setRequestID(" ");
        indication.setStatus(status);
        indication.setErrorMessage(this.getMessageXML(errorMessages));
        this.getLogger().log((Object)indication);
    }

    private int getBuildNumber() {
        if (buildNumber == Integer.MIN_VALUE) {
            buildNumber = new LogAuditAccessIndication().getBuildNumber();
        }
        return buildNumber;
    }

    private String getMessageXML(List<String> errorMessages) {
        StringBuffer sb = new StringBuffer();
        if (errorMessages != null && !errorMessages.isEmpty()) {
            sb.append("<messages>");
            for (String errorMsg : errorMessages) {
                sb.append("<message><messageString>");
                sb.append(errorMsg);
                sb.append("</messageString></message>");
            }
            sb.append("</messages>");
        }
        return sb.toString();
    }

    private LogTypedLogger getLogger() {
        if (this.typedLogger == null) {
            this.typedLogger = LogTypedLogger.getInstance((String)("Audit.Other.DISP." + VisualisationGalleryService.class.getName()), LogIndication.class);
        }
        return this.typedLogger;
    }

    public static final GalleryServiceIPFLogging getInstance() {
        return INSTANCE;
    }
}

