/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.parser;

import com.ibm.ba.vis.vgs.resources.ResourceManager;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;

public class DefinitionParser {
    private static final QName RESOURCE_ATTRIBUTE = new QName("ids");
    private final XMLInputFactory inputFactory;
    private final XMLOutputFactory outputFactory;
    private final XMLEventFactory eventFactory;

    public DefinitionParser(XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory) {
        this.inputFactory = inputFactory;
        this.outputFactory = outputFactory;
        this.eventFactory = eventFactory;
    }

    public InputStream parse(InputStream definition, String language, ResourceManager resources) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ParseState state = new ParseState();
            XMLEventReader reader = this.inputFactory.createXMLEventReader(definition);
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(outputStream);
            while (reader.hasNext()) {
                state.setEvent(reader.nextEvent());
                if (state.getEvent().isStartElement()) {
                    this.processStartElement(language, resources, state);
                } else if (state.isReplace() && state.getEvent().isEndElement()) {
                    this.replaceEndElementCharacters(state, writer);
                } else if (state.isReplace() && state.getEvent().isCharacters()) {
                    this.replaceCharacters(state);
                }
                writer.add(state.getEvent());
            }
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            IOUtils.closeQuietly((InputStream)definition);
        }
        byte[] output = DefinitionParser.removeProlog(outputStream.toByteArray());
        return new ByteArrayInputStream(output);
    }

    public InputStream parse(InputStream definition, String language, ResourceManager resources, String extraInfo) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ParseState state = new ParseState();
            XMLEventReader reader = this.inputFactory.createXMLEventReader(definition);
            XMLEventWriter writer = this.outputFactory.createXMLEventWriter(outputStream);
            boolean findElement = false;
            while (reader.hasNext()) {
                state.setEvent(reader.nextEvent());
                if (state.getEvent().isStartElement()) {
                    if (state.getEvent().asStartElement().getName().getLocalPart().equals(extraInfo)) {
                        findElement = true;
                    }
                    if (!findElement) continue;
                    this.processStartElement(language, resources, state);
                    writer.add(state.getEvent());
                    continue;
                }
                if (state.getEvent().isEndElement()) {
                    if (findElement) {
                        if (state.isReplace()) {
                            this.replaceEndElementCharacters(state, writer);
                        }
                        writer.add(state.getEvent());
                    }
                    if (!state.getEvent().asEndElement().getName().getLocalPart().equals(extraInfo)) continue;
                    findElement = false;
                    continue;
                }
                if (!state.getEvent().isCharacters() || !findElement) continue;
                if (state.isReplace()) {
                    this.replaceCharacters(state);
                }
                writer.add(state.getEvent());
            }
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            IOUtils.closeQuietly((InputStream)definition);
        }
        byte[] output = DefinitionParser.removeProlog(outputStream.toByteArray());
        return new ByteArrayInputStream(output);
    }

    static byte[] removeProlog(byte[] output) {
        byte[] start;
        if (output != null && output.length > 4 && Arrays.equals(start = ArrayUtils.subarray((byte[])output, (int)0, (int)2), "<?".getBytes())) {
            int idxa = ArrayUtils.indexOf((byte[])output, (byte)63, (int)2);
            int idxb = ArrayUtils.indexOf((byte[])output, (byte)62, (int)2);
            if (idxb - idxa == 1) {
                return ArrayUtils.subarray((byte[])output, (int)(idxb + 1), (int)output.length);
            }
        }
        return output;
    }

    private ParseState replaceCharacters(ParseState state) {
        Characters content = this.eventFactory.createCharacters(state.getValue());
        if (!content.isIgnorableWhiteSpace()) {
            state.setEvent(content);
            state.setReplace(false);
        }
        return state;
    }

    private ParseState replaceEndElementCharacters(ParseState state, XMLEventWriter writer) throws XMLStreamException {
        Characters content = this.eventFactory.createCharacters(state.getValue());
        writer.add(content);
        state.setReplace(false);
        return state;
    }

    private ParseState processStartElement(String language, ResourceManager resources, ParseState state) {
        StartElement element = (StartElement)state.getEvent();
        Attribute attribute = element.getAttributeByName(RESOURCE_ATTRIBUTE);
        if (attribute != null) {
            state.setValue(resources.getString(attribute.getValue(), language));
            state.setReplace(this.shouldReplace(state.getValue()));
            List<Attribute> attrList = this.getResourceAttributes(element);
            state.setEvent(this.eventFactory.createStartElement(element.getName(), attrList.iterator(), element.getNamespaces()));
        }
        return state;
    }

    private boolean shouldReplace(String value) {
        return value != null;
    }

    private List<Attribute> getResourceAttributes(StartElement element) {
        Iterator<Attribute> attributes = element.getAttributes();
        ArrayList<Attribute> attrList = new ArrayList<Attribute>();
        while (attributes.hasNext()) {
            Attribute attr = attributes.next();
            if (attr.getName().equals(RESOURCE_ATTRIBUTE)) continue;
            attrList.add(attr);
        }
        return attrList;
    }

    private static class ParseState {
        private String value = null;
        private boolean isReplace = false;
        private XMLEvent event = null;

        private ParseState() {
        }

        String getValue() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }

        boolean isReplace() {
            return this.isReplace;
        }

        void setReplace(boolean isReplace) {
            this.isReplace = isReplace;
        }

        XMLEvent getEvent() {
            return this.event;
        }

        void setEvent(XMLEvent event) {
            this.event = event;
        }
    }
}

