/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.resources;

import com.ibm.ba.vis.vgs.resources.ResourceBundleControl;
import com.ibm.ba.vis.vgs.resources.ResourceManager;
import com.ibm.ba.vis.vgs.resources.VGSLocaleUtils;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class DefaultResourceManager
implements ResourceManager {
    private static final String SERVER_RESOURCES = "vgs";
    private final ResourceBundleControl resourceControl;

    DefaultResourceManager(ResourceBundleControl resourceControl) {
        this.resourceControl = resourceControl;
    }

    @Override
    public String getString(String resourceId, String language) {
        ResourceBundle serverResources;
        Locale locale = VGSLocaleUtils.resolveLocale(language);
        String visResouceBaseName = this.resourceControl.getResourceBaseName();
        ResourceBundle visResources = this.getResourceBundle(locale, visResouceBaseName);
        String value = null;
        if (visResources != null) {
            value = this.getResourceValue(resourceId, visResources);
        }
        if (value == null && (serverResources = this.getServerResourceBundle(locale)) != null) {
            value = this.getResourceValue(resourceId, serverResources);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private ResourceBundle getServerResourceBundle(Locale locale) {
        try {
            return PropertyResourceBundle.getBundle(SERVER_RESOURCES, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private ResourceBundle getResourceBundle(Locale locale, String visResouceBaseName) {
        try {
            return PropertyResourceBundle.getBundle(visResouceBaseName, locale, this.resourceControl);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String getResourceValue(String resourceId, ResourceBundle resources) {
        try {
            return resources.getString(resourceId);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

