/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

class ResourceBundleControl
extends ResourceBundle.Control {
    private static final String BUNDLE_RESOURCES = "/msg";
    private final Map<String, ResourceBundle> bundles = new ConcurrentHashMap<String, ResourceBundle>();
    private final File directory;

    ResourceBundleControl(File directory) {
        this.directory = directory;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        ResourceBundle bundle = null;
        if ("java.properties".equals(format)) {
            String name = StringUtils.removeStart((String)baseName, (String)this.getVisPath());
            String bundleName = this.toBundleName(name, locale);
            String resource = this.toResourceName(bundleName, "properties");
            if (reload) {
                bundle = this.loadBundle(resource);
            } else {
                bundle = this.bundles.get(resource);
                if (bundle == null && (bundle = this.loadBundle(resource)) != null) {
                    this.bundles.put(resource, bundle);
                }
            }
        } else if ("java.class".equals(format)) {
            bundle = null;
        } else {
            throw new IllegalArgumentException("Format must be one of 'java.properties' or 'java.class'");
        }
        return bundle;
    }

    String getResourceBaseName() {
        return this.getVisPath() + BUNDLE_RESOURCES;
    }

    private String getVisPath() {
        return this.directory.getAbsolutePath();
    }

    private ResourceBundle loadBundle(String resource) throws IOException {
        PropertyResourceBundle bundle = null;
        File properties = new File(this.directory, resource);
        if (properties.exists()) {
            FileInputStream stream = new FileInputStream(properties);
            bundle = new PropertyResourceBundle(stream);
        }
        return bundle;
    }
}

