/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.vis.vgs.resources;

import com.ibm.ba.vis.vgs.error.GalleryAPIErrorCode;
import com.ibm.ba.vis.vgs.error.GalleryServiceException;
import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang.StringUtils;

public final class VGSLocaleUtils {
    private static final int COUNTRY_CODE_LENGHT = 2;

    private VGSLocaleUtils() {
    }

    public static Locale resolveLocale(String language) {
        Locale locale = Locale.getDefault();
        if (StringUtils.isNotEmpty((String)language)) {
            try {
                String formatedLanguage = VGSLocaleUtils.formatCountryCode(language);
                locale = LocaleUtils.toLocale((String)formatedLanguage);
            }
            catch (IllegalArgumentException e) {
                throw new GalleryServiceException(GalleryAPIErrorCode.galleryRequestError, (Throwable)e);
            }
        }
        return locale;
    }

    static String formatCountryCode(String language) {
        String formatedLanguage;
        if (language.length() > 4) {
            formatedLanguage = VGSLocaleUtils.formatCountryCodePrefix(language);
            int countryStart = 3;
            int countryEnd = countryStart + 2;
            if (countryStart > 0 && formatedLanguage.length() >= countryEnd) {
                String country = formatedLanguage.substring(countryStart, countryEnd);
                StringBuilder sb = new StringBuilder();
                sb.append(formatedLanguage.substring(0, countryStart));
                sb.append(country.toUpperCase(Locale.ROOT));
                VGSLocaleUtils.formatVariantPrefix(formatedLanguage, countryEnd, sb);
                formatedLanguage = sb.toString();
            }
        } else {
            formatedLanguage = language;
        }
        return formatedLanguage;
    }

    private static String formatCountryCodePrefix(String language) {
        int dashIndex = language.indexOf(45);
        String formatedLanguage = dashIndex == 2 ? language.substring(0, 2) + '_' + language.substring(3) : language;
        return formatedLanguage;
    }

    private static void formatVariantPrefix(String language, int countryEnd, StringBuilder sb) {
        if (language.length() > countryEnd && language.charAt(countryEnd) == '-') {
            sb.append('_');
            sb.append(language.substring(countryEnd + 1));
        } else {
            sb.append(language.substring(countryEnd));
        }
    }
}

