/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.core;

import com.ibm.cognos.rs.core.BaseWebApplicationModule;
import com.ibm.cognos.rs.core.ErrorResponse;
import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.core.RequestHandler;
import com.ibm.cognos.rs.core.Response;
import com.ibm.cognos.rs.core.ResponseBuilder;
import com.ibm.cognos.rs.core.ResponseContent;
import com.ibm.cognos.rs.core.ResponseContentFactory;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import com.ibm.cognos.rs.core.utils.LogUtils;
import com.ibm.cognos.rs.path.BaseRequestPath;
import com.ibm.cognos.rs.path.ResourceMatcher;
import com.ibm.cognos.rs.resource.BindDescriptor;
import com.ibm.cognos.rs.resource.ResourceBinder;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;

class BaseRequestHandler
implements RequestHandler {
    private final BaseWebApplicationModule module;

    BaseRequestHandler(BaseWebApplicationModule module) {
        this.module = module;
    }

    @Override
    public void handle(RequestContext context) {
        try {
            this.handleRequest(context);
        }
        catch (WebApplicationException wae) {
            this.logWebApplicationException(wae);
            this.respond(new ErrorResponse(wae, context.getLocale()), context);
        }
        catch (Throwable e) {
            this.logThrowable(e);
            this.respond(new ErrorResponse(new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR), context.getLocale()), context);
        }
    }

    private void handleRequest(RequestContext context) {
        String requestURI = context.getRequestURI().getPath().replaceFirst("[\\/]?" + this.module.getApplicationRoot() + "[\\/]", "");
        BaseRequestPath requestPath = new BaseRequestPath(requestURI);
        this.logRequestURI(requestURI);
        Collection<ResourceBinder> binders = this.module.getResourceCollection();
        boolean hasMatchingResource = false;
        for (ResourceBinder resourceBinder : binders) {
            ResourceMatcher matcher = resourceBinder.getMatcher(requestPath);
            hasMatchingResource = matcher.matches();
            if (!hasMatchingResource) continue;
            BindDescriptor matchingDescriptor = resourceBinder.get(context.getRequestType());
            if (matchingDescriptor != null) {
                Map<String, String> parameterMap = matcher.getParameterMap();
                this.handleRequest(context, matchingDescriptor, parameterMap);
                break;
            }
            WebApplicationException wae = new WebApplicationException(Status.NOT_IMPLEMENTED);
            ErrorResponse response = new ErrorResponse(wae, context.getLocale());
            this.respond(response, context);
            if (!this.getLog().isDebugEnabled()) break;
            this.getLog().debug((Object)((Object)((Object)context.getRequestType()) + " not supported for the request: " + requestURI));
            break;
        }
        if (!hasMatchingResource) {
            WebApplicationException wae = new WebApplicationException(Status.NOT_FOUND);
            ErrorResponse response = new ErrorResponse(wae, context.getLocale());
            this.respond(response, context);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("No matching resource for: " + requestURI));
            }
        }
    }

    private void logRequestURI(String requestURI) {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requested URI: " + requestURI));
        }
    }

    private void handleRequest(RequestContext context, BindDescriptor matchingBinder, Map<String, String> parameterMap) {
        Response<String> response;
        try {
            if (Void.TYPE.equals(matchingBinder.getReturnType())) {
                matchingBinder.handleRequest(parameterMap, context);
                response = ResponseBuilder.ok();
            } else if (Response.class.isAssignableFrom(matchingBinder.getReturnType())) {
                response = (Response)matchingBinder.handleRequest(parameterMap, context);
            } else {
                Object value = matchingBinder.handleRequest(parameterMap, context);
                response = ResponseBuilder.ok(value, matchingBinder.getProducedMediaType());
            }
        }
        catch (WebApplicationException e) {
            this.logWebApplicationException(e);
            response = new ErrorResponse(e, context.getLocale());
        }
        catch (Throwable e) {
            this.logThrowable(e);
            response = new ErrorResponse(new WebApplicationException(Status.INTERNAL_SERVER_ERROR), context.getLocale());
        }
        this.respond(response, context);
    }

    private void logWebApplicationException(WebApplicationException e) {
        LogUtils.logWebApplicationException(e, this.getLog());
    }

    private void logThrowable(Throwable e) {
        if (this.getLog().isErrorEnabled()) {
            this.getLog().error((Object)e.getMessage(), e);
        }
    }

    private Log getLog() {
        return this.module.getLog();
    }

    private <T> void respond(Response<T> response, RequestContext context) {
        ResponseContentFactory<?> serializer = this.module.getEntitySerializer(response.getEntityClass());
        ResponseContent content = serializer.create(response.getEntity());
        context.writeResponse(response, content);
    }
}

