/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.core;

import com.ibm.cognos.rs.Path;
import com.ibm.cognos.rs.core.BaseRequestHandler;
import com.ibm.cognos.rs.core.DefaultResponseContentFactory;
import com.ibm.cognos.rs.core.InputStreamResponseContentFactory;
import com.ibm.cognos.rs.core.RequestHandler;
import com.ibm.cognos.rs.core.RequestType;
import com.ibm.cognos.rs.core.ResourceProvider;
import com.ibm.cognos.rs.core.ResponseContentFactory;
import com.ibm.cognos.rs.core.WebApplicationModule;
import com.ibm.cognos.rs.path.Template;
import com.ibm.cognos.rs.path.TemplateBuilder;
import com.ibm.cognos.rs.resource.BindDescriptor;
import com.ibm.cognos.rs.resource.DefaultResourceProvider;
import com.ibm.cognos.rs.resource.ResourceBinder;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseWebApplicationModule
implements WebApplicationModule {
    private final TemplateBuilder templateBuilder;
    private final String applicationRoot;
    private final RequestHandler requestHandler;
    private final Map<Template, ResourceBinder> resourceMap;
    private final Map<Class<?>, ResponseContentFactory<?>> responseContentFactories;

    protected <T> BaseWebApplicationModule(String applicationRoot) {
        this(applicationRoot, new TemplateBuilder());
    }

    BaseWebApplicationModule(String applicationRoot, TemplateBuilder templateBuilder) {
        this.templateBuilder = templateBuilder;
        this.applicationRoot = applicationRoot;
        this.resourceMap = new ConcurrentHashMap<Template, ResourceBinder>();
        this.responseContentFactories = new ConcurrentHashMap();
        this.requestHandler = new BaseRequestHandler(this);
    }

    @Override
    public abstract void registerResources();

    @Override
    public final RequestHandler getHandler() {
        return this.requestHandler;
    }

    @Override
    public String getApplicationRoot() {
        return this.applicationRoot;
    }

    Collection<ResourceBinder> getResourceCollection() {
        return this.resourceMap.values();
    }

    ResponseContentFactory<?> getEntitySerializer(Class<?> responseEntityClass) {
        ResponseContentFactory<InputStream> responseWritter = null;
        if (this.responseContentFactories.size() > 0) {
            for (Map.Entry<Class<?>, ResponseContentFactory<?>> entry : this.responseContentFactories.entrySet()) {
                if (!entry.getKey().isAssignableFrom(responseEntityClass)) continue;
                responseWritter = entry.getValue();
                break;
            }
        }
        if (responseWritter == null && InputStream.class.isAssignableFrom(responseEntityClass)) {
            responseWritter = new InputStreamResponseContentFactory();
        }
        if (responseWritter == null) {
            responseWritter = DefaultResponseContentFactory.getInstance(responseEntityClass);
        }
        return responseWritter;
    }

    protected final <T> void registerResource(Class<T> resourceClass) {
        this.registerResource(DefaultResourceProvider.getInstance(resourceClass));
    }

    protected final void registerResource(ResourceProvider<?> provider) {
        Method[] resourceMethods;
        Class<?> resourceClass = provider.getProvidedClass();
        Path rootPath = resourceClass.getAnnotation(Path.class);
        if (rootPath == null) {
            throw new RuntimeException("Class not annotated with resource root Path");
        }
        for (Method method : resourceMethods = resourceClass.getMethods()) {
            for (RequestType type : RequestType.values()) {
                if (!method.isAnnotationPresent(type.getAnnotation())) continue;
                Path methodPath = method.getAnnotation(Path.class);
                Template resourceTemplate = this.getResourceTemplate(rootPath, methodPath);
                ResourceBinder binder = this.getResourceBinder(resourceTemplate);
                binder.add(type, new BindDescriptor(provider, method));
            }
        }
    }

    private ResourceBinder getResourceBinder(Template resourceTemplate) {
        ResourceBinder binder = this.resourceMap.get(resourceTemplate);
        if (binder == null) {
            binder = new ResourceBinder(resourceTemplate);
            this.resourceMap.put(resourceTemplate, binder);
        }
        return binder;
    }

    protected final <T> void registerResponseContentFactory(Class<T> responseEntityType, ResponseContentFactory<T> factory) {
        this.responseContentFactories.put(responseEntityType, factory);
    }

    private Template getResourceTemplate(Path rootPath, Path methodPath) {
        StringBuilder sb = new StringBuilder(rootPath.value());
        if (methodPath != null && methodPath.value().length() > 0) {
            if (methodPath.value().charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(methodPath.value());
        }
        return this.templateBuilder.build(sb.toString());
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }
}

