/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.core;

import com.ibm.cognos.rs.core.BaseResponse;
import com.ibm.cognos.rs.core.WebApplicationException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

class ErrorResponse
extends BaseResponse<String> {
    private static final boolean SHOW_STACK_TRACE = Boolean.valueOf(System.getProperty("com.ibm.cognos.rs.stacktraceInErrorBody", "false"));
    private final WebApplicationException wae;
    private final Locale locale;

    ErrorResponse(WebApplicationException wae, Locale locale) {
        super("", wae.getStatus(), new HashMap<String, String>(1, 1.0f));
        this.wae = wae;
        this.locale = locale;
        this.getHeaders().put("Content-Type", "text/plain;charset=utf-8");
    }

    @Override
    public String getEntity() {
        String msg = this.wae.getLocalizedMessage(this.locale);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)msg)) {
            sb.append(msg);
        }
        if (SHOW_STACK_TRACE) {
            sb.append("\r\n");
            sb.append(ExceptionUtils.getFullStackTrace((Throwable)this.wae));
        }
        return sb.toString();
    }
}

