/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.core;

import com.ibm.cognos.rs.core.BaseResponse;
import com.ibm.cognos.rs.core.Response;
import com.ibm.cognos.rs.core.Status;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.util.DateUtil;

public class ResponseBuilder {
    private Status status = Status.OK;
    private String encoding = null;
    private String contentType = null;
    private Date lastModified = null;
    private Date expires = null;
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Set<javax.servlet.http.Cookie> cookieSet = new HashSet<javax.servlet.http.Cookie>();

    ResponseBuilder() {
    }

    public static ResponseBuilder newInstance() {
        return new ResponseBuilder();
    }

    public static Response<String> ok() {
        return new EmptyResponse();
    }

    public static <T> Response<T> ok(T entity) {
        ResponseBuilder builder = ResponseBuilder.newInstance();
        return builder.build(entity);
    }

    public static <T> Response<T> ok(T entity, String contentType) {
        ResponseBuilder builder = ResponseBuilder.newInstance();
        builder.type(contentType);
        return builder.build(entity);
    }

    public <T> Response<T> build(T object) {
        this.setHeaders();
        this.setCookies();
        return new BaseResponse<T>(object, this.status, this.headers);
    }

    public Response<?> build() {
        this.setHeaders();
        this.setCookies();
        return new EmptyResponse(this.status, this.headers);
    }

    private void setHeaders() {
        if (this.lastModified != null) {
            this.headers.put("Last-Modified", DateUtil.formatDate((Date)this.lastModified));
        }
        if (this.contentType != null && !this.headers.containsKey("Content-Type")) {
            this.headers.put("Content-Type", this.contentType);
        }
        if (this.expires != null) {
            this.headers.put("Expires", DateUtil.formatDate((Date)this.expires));
        }
        if (this.encoding != null) {
            this.headers.put("Content-Encoding", this.encoding);
        }
    }

    private void setCookies() {
        if (this.cookieSet.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (javax.servlet.http.Cookie cookie : this.cookieSet) {
                sb.append(ResponseBuilder.toExternalForm(cookie)).append(";");
            }
            this.headers.put("Set-Cookie", sb.toString());
        }
    }

    private static String toExternalForm(javax.servlet.http.Cookie cookie) {
        String domain = cookie.getDomain();
        String name = cookie.getName();
        String value = cookie.getValue();
        String path = cookie.getPath();
        int maxAge = cookie.getMaxAge();
        boolean secure = cookie.getSecure();
        Cookie commonsCookie = new Cookie(domain, name, value, path, maxAge, secure);
        commonsCookie.setVersion(cookie.getVersion());
        commonsCookie.setComment(cookie.getComment());
        return commonsCookie.toExternalForm();
    }

    public ResponseBuilder status(Status status) {
        this.validateArgument((Object)status);
        this.status = status;
        return this;
    }

    public ResponseBuilder encoding(String encoding) {
        this.validateArgument(encoding);
        this.encoding = encoding;
        return this;
    }

    public ResponseBuilder header(String name, String value) {
        this.validateArgument(name);
        this.validateArgument(value);
        this.headers.put(name, value);
        return this;
    }

    public ResponseBuilder replaceAll(Map<String, String> headers) {
        this.validateArgument(headers);
        this.headers.clear();
        this.headers.putAll(headers);
        return this;
    }

    public ResponseBuilder type(String contentType) {
        this.validateArgument(contentType);
        this.contentType = contentType;
        return this;
    }

    public ResponseBuilder cookie(javax.servlet.http.Cookie cookie) {
        this.validateArgument(cookie);
        this.cookieSet.add(cookie);
        return this;
    }

    public ResponseBuilder expires(Date expires) {
        this.validateArgument(expires);
        this.expires = expires;
        return this;
    }

    public ResponseBuilder lastModified(Date lastModified) {
        this.validateArgument(lastModified);
        this.lastModified = lastModified;
        return this;
    }

    private void validateArgument(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static class EmptyResponse
    extends BaseResponse<String> {
        EmptyResponse() {
            this(new HashMap<String, String>(1));
        }

        EmptyResponse(Map<String, String> headers) {
            this(Status.OK, headers);
        }

        EmptyResponse(Status status, Map<String, String> headers) {
            super("", status, headers);
        }
    }
}

