/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.core.utils;

import com.ibm.cognos.rs.core.WebApplicationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class LogUtils {
    public static void logWebApplicationException(WebApplicationException wae, Log log) {
        int statusCode = wae.getStatus().getStatusCode();
        if (statusCode >= 500 && log.isErrorEnabled()) {
            log.error((Object)LogUtils.getMessage(wae), (Throwable)wae);
        } else if (statusCode >= 400 && log.isDebugEnabled()) {
            log.warn((Object)LogUtils.getMessage(wae), (Throwable)wae);
        } else if (statusCode >= 400 && log.isWarnEnabled()) {
            log.warn((Object)LogUtils.getMessage(wae));
        } else if (log.isInfoEnabled()) {
            log.info((Object)LogUtils.getMessage(wae));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)LogUtils.getMessage(wae), (Throwable)wae);
        }
    }

    private static String getMessage(WebApplicationException wae) {
        String msg = wae.getMessage();
        if (StringUtils.isNotEmpty((String)msg)) {
            return msg;
        }
        return wae.getStatus().toString();
    }
}

