/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.path;

import com.ibm.cognos.rs.path.RequestPath;
import com.ibm.cognos.rs.path.ResourceMatcher;
import com.ibm.cognos.rs.path.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class BaseResourceMatcher
implements ResourceMatcher {
    private final Template template;
    private final RequestPath requestPath;
    private Matcher matcher;
    private Map<String, String> parameterMap = Collections.emptyMap();

    BaseResourceMatcher(Template template, RequestPath requestPath) {
        this.template = template;
        this.requestPath = requestPath;
    }

    @Override
    public boolean matches() {
        int requestPartsCount = this.requestPath.getPathParts().size();
        int templatePartcount = this.template.getPartCount();
        boolean hasWildCard = this.template.hasWildCard();
        if (hasWildCard && templatePartcount - 1 > requestPartsCount) {
            return false;
        }
        if (!hasWildCard && templatePartcount != requestPartsCount) {
            return false;
        }
        if (!this.hasMatchingResourceNames()) {
            return false;
        }
        this.matcher = this.template.getPattern().matcher(this.requestPath.getURI());
        return this.matcher.matches();
    }

    private boolean hasMatchingResourceNames() {
        Iterator<String> partsIterator = this.requestPath.getPathParts().iterator();
        ArrayList<String> resourceNames = this.template.getResourceNames();
        int count = 0;
        for (String resourceName : resourceNames) {
            boolean found = false;
            while (partsIterator.hasNext() && !found) {
                String part = partsIterator.next();
                found = resourceName.equals(part);
                if (!found) continue;
                ++count;
            }
            if (partsIterator.hasNext()) continue;
            break;
        }
        return resourceNames.size() == count;
    }

    @Override
    public Map<String, String> getParameterMap() {
        if (this.matcher != null && this.matcher.hitEnd() && this.matcher.groupCount() > 0) {
            List<String> parameterNames = this.template.getParameterNames();
            this.parameterMap = new HashMap<String, String>(parameterNames.size());
            for (int idx = 1; idx <= this.matcher.groupCount(); ++idx) {
                this.parameterMap.put(parameterNames.get(idx - 1), this.matcher.group(idx));
            }
        }
        return this.parameterMap;
    }
}

