/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.path;

import com.ibm.cognos.rs.path.BaseResourceMatcher;
import com.ibm.cognos.rs.path.RequestPath;
import com.ibm.cognos.rs.path.ResourceMatcher;
import com.ibm.cognos.rs.path.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

class BaseTemplate
implements Template {
    private final Pattern templatePattern;
    private final List<String> parameterNames;
    private final int partCount;
    private final ArrayList<String> resourceNames;
    private final boolean hasWildCard;

    BaseTemplate(String tokenizedTemplate, Pattern templatePattern, List<String> parameterNames) {
        this.templatePattern = templatePattern;
        this.parameterNames = parameterNames;
        String[] tokens = StringUtils.split((String)tokenizedTemplate, (char)'/');
        this.partCount = tokens.length;
        this.resourceNames = this.getResourceNames(tokens);
        this.hasWildCard = parameterNames.indexOf("wildcard") >= 0;
    }

    @Override
    public Pattern getPattern() {
        return this.templatePattern;
    }

    @Override
    public List<String> getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public ResourceMatcher getMatcher(RequestPath requestPath) {
        return new BaseResourceMatcher(this, requestPath);
    }

    @Override
    public ArrayList<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public int getPartCount() {
        return this.partCount;
    }

    @Override
    public boolean hasWildCard() {
        return this.hasWildCard;
    }

    private ArrayList<String> getResourceNames(String[] tokens) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String token : tokens) {
            if (token.isEmpty() || token.indexOf(36) >= 0) continue;
            resourceNames.add(token);
        }
        return resourceNames;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.templatePattern == null ? 0 : this.templatePattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseTemplate other = (BaseTemplate)obj;
        return !(this.templatePattern == null ? other.templatePattern != null : !this.templatePattern.pattern().equals(other.templatePattern.pattern()));
    }
}

