/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.path;

import com.ibm.cognos.rs.path.BaseTemplate;
import com.ibm.cognos.rs.path.Template;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateBuilder {
    private static final String WILDCARD_REGEX = "(.*)";
    private static final String WILD_CARD = "*";
    private static final Pattern KEY_NAME_PATTERN = Pattern.compile("(?:^[{][\t ]*(\\w[\\w[.]-]*))|([\\*][\\/]?$)");
    private static final String DEFAULT_PARAMETER_REGEX = "([a-zA-Z0-9_-~!$&'+,;=[.]]+)";
    private static final char REGEX_MARKER = ':';
    private static final char KEY_START = '{';
    private static final char KEY_END = '}';
    private static final char KEY_WILDCARD = '*';
    private static String KEY_MARKER = "$";

    public Template build(String resourcePath) {
        ArrayList<String> rawKeys = this.extractParameterKeys(resourcePath);
        String tokenizedResourcePath = this.tokenizeResourcePath(resourcePath, rawKeys);
        resourcePath = this.replaceCommonPatternsWithTemplates(tokenizedResourcePath);
        resourcePath = this.replaceKeyTokensWithTemplates(resourcePath, rawKeys);
        Pattern templatePattern = Pattern.compile("^[\\/]?" + resourcePath + "[\\/]?$");
        ArrayList<String> parameterNames = this.getParameterNames(rawKeys);
        return new BaseTemplate(tokenizedResourcePath, templatePattern, parameterNames);
    }

    private ArrayList<String> getParameterNames(ArrayList<String> rawKeys) {
        ArrayList<String> parameterNames = new ArrayList<String>(rawKeys.size());
        for (String rawKey : rawKeys) {
            if (WILD_CARD.equals(rawKey)) {
                parameterNames.add("wildcard");
                continue;
            }
            Matcher nameMatcher = KEY_NAME_PATTERN.matcher(rawKey);
            nameMatcher.find();
            parameterNames.add(nameMatcher.group(1));
        }
        return parameterNames;
    }

    private String replaceKeyTokensWithTemplates(String resourcePath, ArrayList<String> rawKeys) {
        for (int idx = 0; idx < rawKeys.size(); ++idx) {
            String parameterRegex = this.getParameterRegex(rawKeys.get(idx));
            resourcePath = resourcePath.replace(KEY_MARKER + idx, parameterRegex);
        }
        return resourcePath;
    }

    private String getParameterRegex(String parameterKey) {
        int regexMarkerIdx = parameterKey.indexOf(58);
        if (regexMarkerIdx > 0) {
            return "(" + parameterKey.substring(regexMarkerIdx + 1, parameterKey.length() - 1) + ")";
        }
        if (parameterKey.equals(WILD_CARD)) {
            return WILDCARD_REGEX;
        }
        return DEFAULT_PARAMETER_REGEX;
    }

    private String replaceCommonPatternsWithTemplates(String resourcePath) {
        for (TemplateReplacement rep : TemplateReplacement.values()) {
            resourcePath = resourcePath.replaceAll(rep.regExp, rep.replacement);
        }
        return resourcePath;
    }

    private String tokenizeResourcePath(String resourcePath, ArrayList<String> rawKeys) {
        for (int idx = 0; idx < rawKeys.size(); ++idx) {
            resourcePath = resourcePath.replace(rawKeys.get(idx), KEY_MARKER + idx);
        }
        return resourcePath;
    }

    private ArrayList<String> extractParameterKeys(String resourcePath) {
        ArrayList<String> rawKeys = new ArrayList<String>();
        for (int idx = 0; idx < resourcePath.length(); ++idx) {
            if (resourcePath.charAt(idx) == '{') {
                StringBuilder rawKey = new StringBuilder();
                rawKey.append(resourcePath.charAt(idx));
                int innerMark = 0;
                while (++idx < resourcePath.length() && innerMark >= 0) {
                    if (resourcePath.charAt(idx) == '{') {
                        ++innerMark;
                    } else if (resourcePath.charAt(idx) == '}') {
                        --innerMark;
                    }
                    rawKey.append(resourcePath.charAt(idx));
                }
                innerMark = 0;
                rawKeys.add(rawKey.toString());
                continue;
            }
            if (!this.isWildcardOnIndex(idx, resourcePath)) continue;
            rawKeys.add(WILD_CARD);
        }
        return rawKeys;
    }

    private boolean isWildcardOnIndex(int index, String resourcePath) {
        return resourcePath.charAt(index) == '*' && (index + 1 == resourcePath.length() || resourcePath.charAt(index + 1) == '/' && index + 2 == resourcePath.length());
    }

    private static enum TemplateReplacement {
        LEADING_URI_SEAPRATOR("^[\\/]?", ""),
        DOTS("[.]", "[.]");

        private final String regExp;
        private final String replacement;

        private TemplateReplacement(String regExp, String replacement) {
            this.regExp = regExp;
            this.replacement = replacement;
        }
    }
}

