/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.pogo;

import com.cognos.pogo.http.mime.MIMEPartParser;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.core.RequestType;
import com.ibm.cognos.rs.core.Response;
import com.ibm.cognos.rs.core.ResponseContent;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import com.ibm.cognos.rs.pogo.HTTPHeaders;
import com.ibm.cognos.rs.pogo.HeaderName;
import com.ibm.cognos.rs.pogo.PogoResponseWriter;
import com.ibm.cognos.rs.pogo.PogoServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.ParameterParser;
import org.apache.commons.httpclient.util.URIUtil;

class PogoRequestContext
implements RequestContext {
    private static final String PRODUCT_LOCALE = "locale";
    private static final String HTTP_SERVLET_REQUEST = "http_servlet_request";
    private final MessageContext msgContext;
    private final PogoResponseWriter responseWriter;
    private URI requestURI;
    private URL requestURL;
    private Map<String, String> queryParameters;
    private Map<String, Cookie> cookieMap;
    private HTTPHeaders requestHeaders;
    private RequestType requestType;
    private String scriptName;
    private List<InputStream> attachments;
    private HttpServletRequest httpServletRequest;

    PogoRequestContext(MessageContext msgContext) {
        this(msgContext, new PogoResponseWriter());
    }

    PogoRequestContext(MessageContext msgContext, PogoResponseWriter responseWriter) {
        this.msgContext = msgContext;
        this.responseWriter = responseWriter;
    }

    void processContext() {
        BIBusEnvelope env = (BIBusEnvelope)this.msgContext.getProperty("request.envelope");
        String queryParams = env.getFormFieldValuesAsQueryString();
        String path = this.msgContext.getStrProperty("path_info");
        this.createRequestURI(path, queryParams);
        this.requestURL = this.processRequestURL();
        this.queryParameters = this.processQueryString(this.requestURI.getQuery());
        this.requestType = this.getRequestType(env);
        this.scriptName = this.getScriptName(env);
        this.requestHeaders = this.processRequestHeaders();
        this.cookieMap = this.processCookies();
        this.attachments = this.processAttachments();
        this.httpServletRequest = new PogoServletRequestWrapper(this.getServletRequest(), this.getRequestBodyStream());
    }

    private RequestType getRequestType(BIBusEnvelope env) {
        String reqMethod = env.getBiBusHeader().getHdrSession().getEnvironmentVars().getValue("REQUEST_METHOD");
        return RequestType.fromString(reqMethod);
    }

    private String getScriptName(BIBusEnvelope env) {
        return env.getBiBusHeader().getHdrSession().getEnvironmentVars().getValue("SCRIPT_NAME");
    }

    private void createRequestURI(String path, String queryParams) {
        try {
            path = URIUtil.encodePath((String)path);
            this.requestURI = URI.create(path + "?" + queryParams);
        }
        catch (URIException e) {
            throw new RuntimeException("Failed to process request URI", e);
        }
    }

    private URL processRequestURL() {
        HttpServletRequest servletRequest = this.getServletRequest();
        String requestURL = servletRequest.getRequestURL().toString();
        try {
            return new URL(requestURL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> processQueryString(String queryString) {
        Map<String, String> queryParameters;
        if (queryString == null) {
            queryParameters = Collections.emptyMap();
        } else {
            ParameterParser paramParser = new ParameterParser();
            queryParameters = new HashMap<String, String>();
            List parameterList = paramParser.parse(queryString, '&');
            for (NameValuePair param : parameterList) {
                queryParameters.put(param.getName(), param.getValue());
            }
        }
        return queryParameters;
    }

    private Map<String, Cookie> processCookies() {
        List<Cookie> rCookies = this.getCookies();
        LinkedHashMap<String, Cookie> cookies = new LinkedHashMap<String, Cookie>(rCookies.size(), 1.0f);
        for (Cookie cookie : rCookies) {
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    private HTTPHeaders processRequestHeaders() {
        HttpServletRequest servletRequest = this.getServletRequest();
        Enumeration headerNames = servletRequest.getHeaderNames();
        HTTPHeaders headers = new HTTPHeaders();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String value = servletRequest.getHeader(name);
            headers.put(name, value);
        }
        return headers;
    }

    private List<InputStream> processAttachments() {
        InputStream is;
        ArrayList<InputStream> attachments = new ArrayList<InputStream>();
        Object oAttach = this.msgContext.getProperty("request.attachments");
        Iterator iterator = null;
        if (oAttach instanceof MIMEPartParser) {
            this.requestHeaders.remove("Content-Length");
            this.requestHeaders.remove("Content-Disposition");
            this.requestHeaders.remove("Content-Type");
            MIMEPartParser parts = (MIMEPartParser)oAttach;
            if (parts != null && parts.hasNext()) {
                is = (InputStream)parts.next();
                this.readAttachmentHeaders(is);
                attachments.add(is);
            }
        } else if (oAttach instanceof List) {
            List list = (List)oAttach;
            iterator = list.iterator();
        } else if (oAttach instanceof Iterator) {
            iterator = (Iterator)oAttach;
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof InputStream)) continue;
                is = (InputStream)next;
                this.readAttachmentHeaders(is);
                attachments.add(is);
            }
        }
        return attachments;
    }

    private void readAttachmentHeaders(InputStream is) {
        try {
            Header[] headers = HttpParser.parseHeaders((InputStream)is, (String)"UTF-8");
            if (headers != null && headers.length > 0) {
                this.requestHeaders.putAll(headers);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
    }

    private HttpServletRequest getServletRequest() {
        HttpServletRequest servletRequest = (HttpServletRequest)this.msgContext.getProperty(HTTP_SERVLET_REQUEST);
        return servletRequest;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    @Override
    public URL getRequestURL() {
        return this.requestURL;
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }

    @Override
    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public void writeResponse(Response<?> response, ResponseContent content) {
        this.responseWriter.write(this.msgContext, response, content);
    }

    @Override
    public List<Cookie> getCookies() {
        HttpServletRequest servletRequest = this.getServletRequest();
        Cookie[] rCookies = servletRequest.getCookies();
        if (rCookies != null) {
            return Arrays.asList(rCookies);
        }
        return Collections.emptyList();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.cookieMap.get(name);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        LinkedHashMap requestHeaderMap = new LinkedHashMap(this.requestHeaders.size(), 1.0f);
        for (Map.Entry header : this.requestHeaders.entrySet()) {
            requestHeaderMap.put(((HeaderName)header.getKey()).toString(), header.getValue());
        }
        return Collections.unmodifiableMap(requestHeaderMap);
    }

    @Override
    public String getHeader(String name) {
        return this.requestHeaders.get(name);
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.httpServletRequest;
    }

    @Override
    public InputStream getRequestBodyStream() {
        if (this.attachments.size() > 0) {
            return this.attachments.get(0);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public Locale getLocale() {
        Locale locale = (Locale)this.msgContext.getProperty(PRODUCT_LOCALE);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    @Override
    public String getTimezoneID() {
        BIBusEnvelope envelope = (BIBusEnvelope)this.msgContext.getProperty("request.envelope");
        return envelope.getUserPreferenceValue("timeZoneID");
    }
}

