/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.pogo;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.rs.core.Response;
import com.ibm.cognos.rs.core.ResponseContent;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class PogoResponseWriter {
    PogoResponseWriter() {
    }

    void write(MessageContext messageContext, Response<?> response, ResponseContent content) {
        try {
            ArrayList<InputStream> attachmentList = new ArrayList<InputStream>(1);
            HashMap<String, String> responseHeaders = new HashMap<String, String>(response.getHeaders());
            if (responseHeaders.get("Content-Length") == null && content.lenght() > 0) {
                responseHeaders.put("Content-Length", String.valueOf(content.lenght()));
            }
            InputStream contentStream = this.createAttachmentStream(content.getContentStream(), responseHeaders);
            attachmentList.add(contentStream);
            this.respondAsAttachment(messageContext, attachmentList, response.getStatus().getStatusCode());
        }
        catch (RuntimeException e) {
            if (content != null) {
                content.release();
            }
            throw e;
        }
        catch (Exception e) {
            if (content != null) {
                content.release();
            }
            throw new RuntimeException(e);
        }
    }

    InputStream createAttachmentStream(InputStream contentStream, Map<String, String> headers) {
        byte[] headerBytes = PogoResponseWriter.toByteArray(headers);
        SequenceInputStream content = new SequenceInputStream(new ByteArrayInputStream(headerBytes), contentStream);
        return content;
    }

    void respondAsAttachment(MessageContext mc, List<InputStream> attachmentList, int status) {
        this.setResponseEnvelope(mc);
        mc.setProperty("response.attachments", attachmentList.iterator());
        mc.setProperty("response.boundary", (Object)StringUtils.getUniqueValue());
        mc.setProperty("response.status_code", (Object)Integer.toString(status));
    }

    private void setResponseEnvelope(MessageContext mc) {
        BIBusEnvelope bus = (BIBusEnvelope)mc.getProperty("request.envelope");
        mc.setResponseName("response");
        mc.setProperty("response.envelope", (Object)bus);
    }

    static byte[] toByteArray(Map<String, String> headers) {
        try {
            StringBuffer buffer = new StringBuffer();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    buffer.append(header.getKey());
                    buffer.append(": ");
                    buffer.append(header.getValue());
                    buffer.append("\r\n");
                }
            }
            buffer.append("\r\n");
            return buffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new WebApplicationException(Status.INTERNAL_SERVER_ERROR);
        }
    }
}

