/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.resource;

import com.ibm.cognos.rs.resource.ParameterDescriptor;
import com.ibm.cognos.rs.resource.ParameterType;
import com.ibm.cognos.rs.resource.ValueParser;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

class BaseParameterDescriptor<T>
implements ParameterDescriptor<T> {
    private final int paramIdx;
    private final ParameterType parameterType;
    private final T defaultValue;
    private final ValueParser<T> valueParser;
    private final String annotatedName;
    private final boolean isDecodeEnabled;

    public BaseParameterDescriptor(int paramIdx, String annotatedName, ParameterType parameterType, T defaultValue, ValueParser<T> valueParser) {
        this(paramIdx, annotatedName, parameterType, defaultValue, valueParser, true);
    }

    public BaseParameterDescriptor(int paramIdx, String annotatedName, ParameterType parameterType, T defaultValue, ValueParser<T> valueParser, boolean decode) {
        this.paramIdx = paramIdx;
        this.annotatedName = annotatedName;
        this.parameterType = parameterType;
        this.defaultValue = defaultValue;
        this.valueParser = valueParser;
        this.isDecodeEnabled = decode;
    }

    @Override
    public int parameterIndex() {
        return this.paramIdx;
    }

    @Override
    public ParameterType getType() {
        return this.parameterType;
    }

    @Override
    public String getAnnotatedName() {
        return this.annotatedName;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T parseValue(String value) {
        Object parsedValue = null;
        if (value != null && this.isDecodeEnabled) {
            value = this.decodeValue(value);
        }
        parsedValue = this.valueParser.parse(value);
        if (this.defaultValue != null && this.valueParser.isParserDefault(parsedValue)) {
            parsedValue = this.getDefaultValue();
        }
        return parsedValue;
    }

    private String decodeValue(String value) {
        try {
            value = URIUtil.decode((String)value);
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        return value;
    }
}

