/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.resource;

import com.ibm.cognos.rs.Produces;
import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.core.ResourceProvider;
import com.ibm.cognos.rs.core.Status;
import com.ibm.cognos.rs.core.WebApplicationException;
import com.ibm.cognos.rs.resource.ParameterDescriptor;
import com.ibm.cognos.rs.resource.ParameterDescriptorBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BindDescriptor {
    private final ResourceProvider<?> resourceProvider;
    private final Method handlerMethod;
    private final int parameterNumber;
    private final List<ParameterDescriptor<?>> parameterDescriptors;
    private final String producedType;

    public BindDescriptor(ResourceProvider<?> resourceProvider, Method handlerMethod) {
        this.handlerMethod = handlerMethod;
        this.resourceProvider = resourceProvider;
        Produces produces = handlerMethod.getAnnotation(Produces.class);
        this.producedType = produces != null ? produces.value() : "text/plain";
        this.parameterNumber = handlerMethod.getParameterTypes().length;
        this.parameterDescriptors = new ArrayList(this.parameterNumber);
        this.populateParameterDescriptors();
    }

    private void populateParameterDescriptors() {
        Annotation[][] paramAnnotations = this.handlerMethod.getParameterAnnotations();
        Class<?>[] paramTypes = this.handlerMethod.getParameterTypes();
        for (int idx = 0; idx < this.parameterNumber; ++idx) {
            ParameterDescriptor<?> paramDescriptor = ParameterDescriptorBuilder.build(idx, paramTypes[idx], paramAnnotations[idx]);
            if (paramDescriptor == null) continue;
            this.parameterDescriptors.add(paramDescriptor);
        }
    }

    public Object handleRequest(Map<String, String> resourceParameterMap, RequestContext context) {
        Object resource = this.resourceProvider.provide();
        try {
            Object[] parameters = this.getMethodParameters(resourceParameterMap, context);
            if (Void.TYPE.equals(this.getReturnType())) {
                this.handlerMethod.invoke(resource, parameters);
                return null;
            }
            return this.handlerMethod.invoke(resource, parameters);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new WebApplicationException(e.getCause(), Status.INTERNAL_SERVER_ERROR);
            }
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(e, Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Class<?> getReturnType() {
        return this.handlerMethod.getReturnType();
    }

    public String getProducedMediaType() {
        return this.producedType;
    }

    private Object[] getMethodParameters(Map<String, String> parameterMap, RequestContext context) {
        Object[] parameterValues = new Object[this.parameterNumber];
        for (ParameterDescriptor<?> descriptor : this.parameterDescriptors) {
            String paramStringValue = null;
            RequestContext value = null;
            switch (descriptor.getType()) {
                case PATH: {
                    paramStringValue = parameterMap.get(descriptor.getAnnotatedName());
                    value = descriptor.parseValue(paramStringValue);
                    break;
                }
                case QUERY: {
                    paramStringValue = context.getQueryParameters().get(descriptor.getAnnotatedName());
                    value = descriptor.parseValue(paramStringValue);
                    break;
                }
                case HEADER: {
                    paramStringValue = context.getHeader(descriptor.getAnnotatedName());
                    value = descriptor.parseValue(paramStringValue);
                    break;
                }
                case COOKIE: {
                    value = context.getCookie(descriptor.getAnnotatedName());
                    break;
                }
                case CONTEXT: {
                    value = context;
                    break;
                }
            }
            parameterValues[descriptor.parameterIndex()] = value;
        }
        return parameterValues;
    }
}

