/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.resource;

import com.ibm.cognos.rs.Context;
import com.ibm.cognos.rs.CookieParameter;
import com.ibm.cognos.rs.DefaultValue;
import com.ibm.cognos.rs.Encoded;
import com.ibm.cognos.rs.HeaderParameter;
import com.ibm.cognos.rs.PathParameter;
import com.ibm.cognos.rs.QueryParameter;
import com.ibm.cognos.rs.resource.BaseParameterDescriptor;
import com.ibm.cognos.rs.resource.ParameterDescriptor;
import com.ibm.cognos.rs.resource.ParameterType;
import com.ibm.cognos.rs.resource.ParserBuilder;
import com.ibm.cognos.rs.resource.ValueParser;
import java.lang.annotation.Annotation;
import javax.servlet.http.Cookie;

class ParameterDescriptorBuilder {
    private static final String CONTEXT_PARAM_NAME = "context";

    ParameterDescriptorBuilder() {
    }

    public static <T> ParameterDescriptor<T> build(int paramIdx, Class<T> parameterClazz, Annotation[] parameterAnnotations) {
        ParameterType parameterType = null;
        String annotatedName = null;
        String defaultValueString = null;
        boolean isDecodeEnabled = true;
        for (Annotation annotation : parameterAnnotations) {
            if (annotation instanceof PathParameter) {
                parameterType = ParameterType.PATH;
                annotatedName = ((PathParameter)annotation).value();
                continue;
            }
            if (annotation instanceof QueryParameter) {
                parameterType = ParameterType.QUERY;
                annotatedName = ((QueryParameter)annotation).value();
                continue;
            }
            if (annotation instanceof HeaderParameter) {
                parameterType = ParameterType.HEADER;
                annotatedName = ((HeaderParameter)annotation).value();
                continue;
            }
            if (annotation instanceof CookieParameter) {
                if (parameterClazz.isAssignableFrom(Cookie.class)) {
                    parameterType = ParameterType.COOKIE;
                    annotatedName = ((CookieParameter)annotation).value();
                    continue;
                }
                throw new RuntimeException("A cookie parameter annotation can only be binded to a parameter of class " + Cookie.class);
            }
            if (annotation instanceof Context) {
                parameterType = ParameterType.CONTEXT;
                annotatedName = CONTEXT_PARAM_NAME;
                continue;
            }
            if (annotation instanceof DefaultValue) {
                defaultValueString = ((DefaultValue)annotation).value();
                continue;
            }
            if (!(annotation instanceof Encoded)) continue;
            isDecodeEnabled = false;
        }
        if (parameterType != null && annotatedName != null) {
            ValueParser<T> valueParser = ParserBuilder.build(parameterClazz);
            Object defaultValue = null;
            if (defaultValueString != null) {
                defaultValue = valueParser.parse(defaultValueString);
            }
            return new BaseParameterDescriptor<Object>(paramIdx, annotatedName, parameterType, defaultValue, (ValueParser<Object>)valueParser, isDecodeEnabled);
        }
        return null;
    }
}

