/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.rs.resource;

import com.ibm.cognos.rs.core.RequestContext;
import com.ibm.cognos.rs.resource.ValueParser;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.http.Cookie;

final class ParserBuilder {
    private static final ValueParser<Byte> BYTE_PARSER = new DefaultValueParser<Byte>(Byte.class, (byte)0);
    private static final ValueParser<Short> SHORT_PARSER = new DefaultValueParser<Short>(Short.class, (short)0);
    private static final ValueParser<Integer> INTEGER_PARSER = new DefaultValueParser<Integer>(Integer.class, 0);
    private static final ValueParser<Long> LONG_PARSER = new DefaultValueParser<Long>(Long.class, 0L);
    private static final ValueParser<Float> FLOAT_PARSER = new DefaultValueParser<Float>(Float.class, Float.valueOf(0.0f));
    private static final ValueParser<Double> DOUBLE_PARSER = new DefaultValueParser<Double>(Double.class, 0.0);
    private static final ValueParser<Boolean> BOOLEAN_PARSER = new DefaultValueParser<Boolean>(Boolean.class, false);
    private static final ValueParser<Character> CHAR_PARSER = new CharacterParser();
    private static final ValueParser<String> STRING_PARSER = new StringValueParser();

    ParserBuilder() {
    }

    static <T> ValueParser<T> build(Class<T> parameterClazz) {
        if (String.class.equals(parameterClazz)) {
            return STRING_PARSER;
        }
        if (Byte.TYPE.equals(parameterClazz)) {
            return BYTE_PARSER;
        }
        if (Short.TYPE.equals(parameterClazz)) {
            return SHORT_PARSER;
        }
        if (Integer.TYPE.equals(parameterClazz)) {
            return INTEGER_PARSER;
        }
        if (Long.TYPE.equals(parameterClazz)) {
            return LONG_PARSER;
        }
        if (Float.TYPE.equals(parameterClazz)) {
            return FLOAT_PARSER;
        }
        if (Double.TYPE.equals(parameterClazz)) {
            return DOUBLE_PARSER;
        }
        if (Boolean.TYPE.equals(parameterClazz)) {
            return BOOLEAN_PARSER;
        }
        if (Character.TYPE.equals(parameterClazz) || Character.class.equals(parameterClazz)) {
            return CHAR_PARSER;
        }
        if (RequestContext.class.equals(parameterClazz)) {
            return ParserBuilder.getNullParser();
        }
        if (Cookie.class.isAssignableFrom(parameterClazz)) {
            return ParserBuilder.getNullParser();
        }
        return new DefaultValueParser(parameterClazz, null);
    }

    private static final <T> ValueParser<T> getNullParser() {
        return new NullParser();
    }

    private static class DefaultValueParser<T>
    implements ValueParser<T> {
        private final Method valueOfMethod;
        private final T defaultValue;

        private DefaultValueParser(Class<T> clazz, T defaultValue) {
            this.defaultValue = defaultValue;
            try {
                this.valueOfMethod = clazz.getMethod("valueOf", String.class);
                int methodModifiers = this.valueOfMethod.getModifiers();
                if (!(Modifier.isPublic(methodModifiers) && Modifier.isStatic(methodModifiers) && clazz.isAssignableFrom(this.valueOfMethod.getReturnType()))) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(clazz.getName() + " does not have a public static method valueOf(String)");
            }
        }

        @Override
        public T parse(String value) {
            Object parsedValue = this.defaultValue;
            if (value != null) {
                try {
                    parsedValue = this.valueOfMethod.invoke(null, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return parsedValue;
        }

        @Override
        public boolean isParserDefault(T value) {
            if (this.defaultValue == null) {
                return value == null;
            }
            return this.defaultValue.equals(value);
        }
    }

    private static class CharacterParser
    implements ValueParser<Character> {
        private final Character JRE_CHAR_DEFAULT = Character.valueOf('\u0000');

        private CharacterParser() {
        }

        @Override
        public Character parse(String value) {
            if (value == null || value.isEmpty()) {
                return this.JRE_CHAR_DEFAULT;
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public boolean isParserDefault(Character value) {
            return this.JRE_CHAR_DEFAULT.equals(value);
        }
    }

    private static class NullParser<T>
    implements ValueParser<T> {
        private NullParser() {
        }

        @Override
        public T parse(String value) {
            return null;
        }

        @Override
        public boolean isParserDefault(T value) {
            return true;
        }
    }

    private static class StringValueParser
    implements ValueParser<String> {
        private StringValueParser() {
        }

        @Override
        public String parse(String value) {
            return value;
        }

        @Override
        public boolean isParserDefault(String value) {
            return value == null;
        }
    }
}

