/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.Configuration;
import com.ibm.vida.rave.core.arrays.Bisector;
import com.ibm.vida.rave.core.arrays.Deviation;
import com.ibm.vida.rave.core.arrays.Extent;
import com.ibm.vida.rave.core.arrays.Mean;
import com.ibm.vida.rave.core.arrays.Median;
import com.ibm.vida.rave.core.arrays.Merge;
import com.ibm.vida.rave.core.arrays.MinMax;
import com.ibm.vida.rave.core.arrays.Nest;
import com.ibm.vida.rave.core.arrays.Pairs;
import com.ibm.vida.rave.core.arrays.Permute;
import com.ibm.vida.rave.core.arrays.Quantile;
import com.ibm.vida.rave.core.arrays.Range;
import com.ibm.vida.rave.core.arrays.RaveSet;
import com.ibm.vida.rave.core.arrays.Shuffle;
import com.ibm.vida.rave.core.arrays.Sort;
import com.ibm.vida.rave.core.arrays.Sum;
import com.ibm.vida.rave.core.arrays.Variance;
import com.ibm.vida.rave.core.arrays.Zip;
import com.ibm.vida.rave.core.behavior.Behavior;
import com.ibm.vida.rave.core.capabilities.Capabilities;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.collections.MapFunctionClass;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.HCL;
import com.ibm.vida.rave.core.color.HSL;
import com.ibm.vida.rave.core.color.LAB;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.css.CSSEngine;
import com.ibm.vida.rave.core.css.CSSStyleDeclaration;
import com.ibm.vida.rave.core.css.CSSStyleRule;
import com.ibm.vida.rave.core.css.CSSStyleSheet;
import com.ibm.vida.rave.core.ease.Easing;
import com.ibm.vida.rave.core.event.Dispatcher;
import com.ibm.vida.rave.core.event.TouchList;
import com.ibm.vida.rave.core.event.TouchUtil;
import com.ibm.vida.rave.core.event.Touches;
import com.ibm.vida.rave.core.format.FormatPrefix;
import com.ibm.vida.rave.core.format.Round;
import com.ibm.vida.rave.core.functions.DoubleValueFunction;
import com.ibm.vida.rave.core.geo.Geo;
import com.ibm.vida.rave.core.geom.Geom;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.geom.Point3;
import com.ibm.vida.rave.core.globalization.Bidi;
import com.ibm.vida.rave.core.graphicUtils.CanvasUtil;
import com.ibm.vida.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.vida.rave.core.internal.transitions.TransitionInfo;
import com.ibm.vida.rave.core.internal.transitions.TransitionTracker;
import com.ibm.vida.rave.core.internal.transitions.TransitionUtil;
import com.ibm.vida.rave.core.interpolate.ArrayInterpolation;
import com.ibm.vida.rave.core.interpolate.ColorInterpolation;
import com.ibm.vida.rave.core.interpolate.Interpolate;
import com.ibm.vida.rave.core.interpolate.InterpolatorFactory;
import com.ibm.vida.rave.core.interpolate.Interpolators;
import com.ibm.vida.rave.core.interpolate.NumberInterpolation;
import com.ibm.vida.rave.core.interpolate.RoundInterpolation;
import com.ibm.vida.rave.core.interpolate.StringInterpolation;
import com.ibm.vida.rave.core.interpolate.TransformInterpolation;
import com.ibm.vida.rave.core.interpolate.ZoomInterpolation;
import com.ibm.vida.rave.core.layout.Layout;
import com.ibm.vida.rave.core.locale.Locale;
import com.ibm.vida.rave.core.locale.NumberFormat;
import com.ibm.vida.rave.core.math.Random;
import com.ibm.vida.rave.core.nativeImpl.arrays.AssociativeArrays;
import com.ibm.vida.rave.core.nativeImpl.dsv.Csv;
import com.ibm.vida.rave.core.nativeImpl.dsv.DsvFactory;
import com.ibm.vida.rave.core.nativeImpl.dsv.Tsv;
import com.ibm.vida.rave.core.nativeImpl.event.EventTracker;
import com.ibm.vida.rave.core.nativeImpl.event.Mouse;
import com.ibm.vida.rave.core.nativeImpl.format.Requote;
import com.ibm.vida.rave.core.nativeImpl.interpolate.ObjectInterpolation;
import com.ibm.vida.rave.core.nativeImpl.timer.Timer;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrHtml;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrIdentity;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrJson;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrText;
import com.ibm.vida.rave.core.nativeImpl.xhr.XhrXml;
import com.ibm.vida.rave.core.scales.Scales;
import com.ibm.vida.rave.core.scene.ImageCreatedCallback;
import com.ibm.vida.rave.core.scene.ImageFactory;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.SVG;
import com.ibm.vida.rave.core.time.Time;
import com.ibm.vida.rave.core.transform.Transform;
import com.ibm.vida.rave.core.transform.TransformParser;
import com.ibm.vida.rave.core.transition.Transition;
import com.ibm.vida.rave.core.util.Comparator;
import com.ibm.vida.rave.core.util.Namespace;
import com.ibm.vida.rave.core.util.RaveUtil;
import com.ibm.vida.rave.core.util.StringFormatter;
import java.util.List;
import java.util.Map;

public final class Rave {
    public static final RaveUtil util;
    public static CSSEngine css;
    public static final CanvasUtil canvas;
    public static final EventTracker event;
    public static Configuration configuration;
    public static Timer timer;
    public static final Geom geom;
    public static final Scales scale;
    public static final Layout layout;
    public static final Capabilities capabilities;
    public static final SVG svg;
    public static final Geo geo;
    public static final Behavior behavior;
    public static final Time time;
    public static final Bidi bidi;
    public static Namespace ns;
    public static final Random random;
    public static final NumberFormat format;
    public static final StringFormatter formatter;
    public static final Locale locale;
    public static final Bisector.BisectorFunction<Object> bisectLeft;
    public static final Bisector.BisectorFunction<Object> bisectRight;
    public static final Bisector.BisectorFunction<Object> bisect;
    public static final Comparator<Object> descending;
    public static final Comparator<Object> ascending;
    public static final Easing ease;
    public static final Class<Color> color;
    public static Interpolators interpolators;
    public static final Interpolate interpolate;
    public static final InterpolatorFactory<Object> interpolateHcl;
    public static final InterpolatorFactory<Object> interpolateHsl;
    public static final InterpolatorFactory<Object> interpolateLab;
    public static final InterpolatorFactory<Object> interpolateRgb;
    public static final InterpolatorFactory<Object> interpolateString;
    public static final InterpolatorFactory<Object> interpolateNumber;
    public static final InterpolatorFactory<Object> interpolateRound;
    public static final InterpolatorFactory<Object[]> interpolateArray;
    public static final InterpolatorFactory<Object> interpolateObject;
    public static final InterpolatorFactory<String> interpolateTransform;
    public static final InterpolatorFactory<Point3> interpolateZoom;
    public static final XhrIdentity xhr;
    public static final XhrText text;
    public static final XhrJson json;
    public static final XhrHtml html;
    public static final XhrXml xml;
    public static final DsvFactory dsv;
    public static final Csv csv;
    public static final Tsv tsv;
    public static final MapFunctionClass map;

    private Rave() {
    }

    public static final Transform transform(String trans) {
        return TransformParser.create(trans);
    }

    public static Selector select(SceneNode node) {
        return new Selector().init(node);
    }

    public static Selector select(String query) {
        return new Selector().init(query);
    }

    public static Selector selectAll(List<SceneNode> nodes) {
        return new Selector().initAll(nodes);
    }

    public static Selector selectAll(String query) {
        return new Selector().initAll(query);
    }

    public static Transition active(SceneNode node, String name) {
        TransitionInfo active;
        Transition activeTransition = null;
        String namespace = TransitionUtil.transitionNamespace(name);
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null && (active = (TransitionInfo)tracker.get((int)tracker.active)) != null) {
            activeTransition = active.getTransition();
        }
        return activeTransition;
    }

    public static ArrayEx<Transition> getTransitions(SceneNode node, String name) {
        ArrayEx<Transition> arrTransitions = new ArrayEx<Transition>();
        String namespace = TransitionUtil.transitionNamespace(name);
        TransitionTracker tracker = (TransitionTracker)node.getProperty(namespace);
        if (tracker != null) {
            for (Integer key : tracker.keySet()) {
                TransitionInfo info = (TransitionInfo)tracker.get(key);
                arrTransitions.add(info.getTransition());
            }
        }
        return arrTransitions;
    }

    public static Transition transition() {
        return Transition.newTransition();
    }

    public static Selection<?> transition(Selection<?> selection) {
        return Transition.newTransition(selection);
    }

    public static Transition transition(String name) {
        return Transition.newTransition(name);
    }

    public static Selection<?> transition(Selection<?> selection, String name) {
        return Transition.newTransition(selection, name);
    }

    public static <E> List<E> merge(List<List<E>> objects) {
        return Merge.merge(objects);
    }

    public static Object max(List<?> numbers) {
        return MinMax.max(numbers);
    }

    public static Object max(List<?> data, ValueFunction<List<?>, ? extends Object> valueFunction) {
        return MinMax.max(data, valueFunction);
    }

    public static Object min(List<?> numbers) {
        return MinMax.min(numbers);
    }

    public static Object min(List<?> data, ValueFunction<List<?>, ? extends Object> valueFunction) {
        return MinMax.min(data, valueFunction);
    }

    public static Number quantile(List<Object> numbers, double p) {
        return Quantile.quantile(numbers, p);
    }

    public static Number deviation(Object[] numbers) {
        return Deviation.deviation(numbers);
    }

    public static Number deviation(Object[] data, ValueFunction<? super Object[], ? extends Number> fn) {
        return Deviation.deviation(data, fn);
    }

    public static Number variance(Object[] numbers) {
        return Variance.variance(numbers);
    }

    public static Number variance(Object[] data, ValueFunction<? super Object[], ? extends Number> fn) {
        return Variance.variance(data, fn);
    }

    public static Number mean(Object[] numbers) {
        return Mean.mean(numbers);
    }

    public static Number mean(Object[] data, ValueFunction<? super Object[], ? extends Number> fn) {
        return Mean.mean(data, fn);
    }

    public static Number median(Object[] numbers) {
        return Median.median(numbers);
    }

    public static Number median(Object[] data, ValueFunction<? super Object[], ? extends Number> fn) {
        return Median.median(data, fn);
    }

    public static List<Object> extent(Object[] array) {
        return Extent.extent(array);
    }

    public static List<Object> extent(Object[] array, ValueFunction<Object[], Object> valueFunction) {
        return Extent.extent(array, valueFunction);
    }

    public static Number sum(List<?> numbers) {
        return Sum.sum(numbers);
    }

    public static Number sum(List<?> data, ValueFunction<List<?>, ? extends Number> valueFunction) {
        return Sum.sum(data, valueFunction);
    }

    public static <T> ArrayEx<ArrayEx<T>> zip(List<T> ... objects) {
        return Zip.zip(objects);
    }

    public static <T> ArrayEx<ArrayEx<T>> transpose(List<T>[] objects) {
        return Zip.zip(objects);
    }

    public static <T> ArrayEx<T> permute(List<T> inputArray, List<Integer> indexes) {
        return Permute.permute(inputArray, indexes);
    }

    public static <T> List<T> shuffle(List<T> inputArray) {
        return Shuffle.shuffle(inputArray);
    }

    public static <T> List<T> shuffle(List<T> inputArray, int start) {
        return Shuffle.shuffle(inputArray, start);
    }

    public static <T> List<T> shuffle(List<T> inputArray, int start, int end) {
        return Shuffle.shuffle(inputArray, start, end);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> range(Object stop) {
        return Range.create(stop);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> range(Object start, Object stop) {
        return Range.create(start, stop);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> range(Object start, Object stop, Object step) {
        return Range.create(start, stop, step);
    }

    public static <T> Bisector<T> bisector(Comparator<T> comparator) {
        return Bisector.create(comparator);
    }

    public static <T> Bisector<T> bisector(DoubleValueFunction<T> f) {
        return Bisector.create(f);
    }

    public static <C> Dispatcher<C> dispatch(String ... types) {
        return Dispatcher.create(types);
    }

    public static Point mouse(SceneNode node) {
        return Mouse.mousePoint(node);
    }

    public static Point touch(SceneNode container, TouchList touches, String identifier) {
        return TouchUtil.touch(container, touches, identifier);
    }

    public static Point touch(SceneNode container, String identifier) {
        return TouchUtil.touchFromSource(container, identifier);
    }

    public static List<Touches.TouchPoint> touches(SceneNode container) {
        return Touches.touches(container);
    }

    public static List<Touches.TouchPoint> touches(SceneNode container, TouchList touches) {
        return Touches.touches(container, touches);
    }

    public static LAB lab(double l, double a, double b) {
        return Colors.newLAB(l, a, b);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static LAB lab(Object color) {
        return Colors.newLAB(color);
    }

    public static HCL hcl(double h, double c, double l) {
        return Colors.newHCL(h, c, l);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static HCL hcl(Object color) {
        return Colors.newHCL(color);
    }

    public static HSL hsl(double h, double s, double l) {
        return Colors.newHSL(h, s, l);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static HSL hsl(Object color) {
        return Colors.newHSL(color);
    }

    public static RGB rgb(int r, int g, int b) {
        return Colors.newRGB(r, g, b);
    }

    @SwiftMethodOverload(overloads={"String"})
    public static RGB rgb(Object color) {
        return Colors.newRGB(color);
    }

    public static RGB rgba(int r, int g, int b, double a) {
        return Colors.newRGBA(r, g, b, a);
    }

    public static final double round(double x, double n) {
        return Round.round(x, n);
    }

    public static final String requote(String s) {
        return Requote.requote(s);
    }

    public static final FormatPrefix formatPrefix(double value, Integer precision) {
        return FormatPrefix.formatPrefix(value, precision);
    }

    public static final ArrayEx<String> keys(Map<String, ?> map) {
        return AssociativeArrays.keys(map);
    }

    public static final ArrayEx<?> values(Map<String, ?> map) {
        return AssociativeArrays.values(map);
    }

    public static final ArrayEx<Map.Entry<String, ?>> entries(Map<String, ?> map) {
        return AssociativeArrays.entries(map);
    }

    public static Nest nest() {
        return new Nest();
    }

    public static final Selector selection() {
        return new Selector().init(PlatformInitialization.getDocumentElement(PlatformInitialization.getDocument()));
    }

    public static Object[] pairs(Object[] array) {
        return Pairs.pairs(array);
    }

    public static final RaveSet set() {
        return RaveSet.create();
    }

    public static final RaveSet set(List<Object> list) {
        return RaveSet.create(list);
    }

    public static final void getImage(SceneNode context, ImageCreatedCallback callback) {
        Configuration config = Configuration.INSTANCE;
        ImageFactory factory = config.getImageFactory(context.getNamespaceURI());
        if (factory != null) {
            factory.create(context, callback);
        }
    }

    public static final void getSVGImage(SceneNode context, ImageCreatedCallback callback) {
        String svgHtml = context.getHtml();
        svgHtml = svgHtml.replaceAll("<root", "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\"");
        svgHtml = svgHtml.replaceAll("</root>", "</svg>");
        StringBuilder inlineStyle = new StringBuilder();
        inlineStyle.append(">");
        inlineStyle.append("<style>");
        ArrayEx<CSSStyleSheet> styleSheets = css.styleSheets();
        for (CSSStyleSheet styleSheet : styleSheets) {
            for (CSSStyleRule rule : styleSheet.getCssRules()) {
                inlineStyle.append(rule.getSelectorText());
                inlineStyle.append("{");
                CSSStyleDeclaration style = rule.getStyle();
                for (int propIdx = 0; propIdx < style.length(); ++propIdx) {
                    String propName = style.item(propIdx);
                    inlineStyle.append(propName + ":");
                    inlineStyle.append(style.getPropertyValue(propName));
                    String priority = style.getPropertyPriority(propName);
                    if (priority.length() > 0) {
                        inlineStyle.append("!" + priority);
                    }
                    inlineStyle.append(";");
                }
                inlineStyle.append("}");
            }
        }
        inlineStyle.append("</style>");
        callback.ready(svgHtml.replaceFirst(">", inlineStyle.toString()));
    }

    static {
        PlatformInitialization.init();
        util = RaveUtil.getInstance();
        css = null;
        canvas = CanvasUtil.INSTANCE;
        event = EventTracker.INSTANCE;
        configuration = Configuration.INSTANCE;
        timer = Timer.INSTANCE;
        geom = Geom.INSTANCE;
        scale = Scales.INSTANCE;
        layout = Layout.INSTANCE;
        capabilities = Capabilities.INSTANCE;
        svg = SVG.getInstance();
        geo = Geo.INSTANCE;
        behavior = Behavior.INSTANCE;
        time = Time.getInstance();
        bidi = Bidi.INSTANCE;
        ns = Namespace.INSTANCE;
        random = Random.INSTANCE;
        format = new NumberFormat(Locale.DEFAULT_LOCALE);
        formatter = StringFormatter.INSTANCE;
        locale = Locale.getInstance();
        bisectLeft = Bisector.bisectLeft;
        bisectRight = Bisector.bisectRight;
        bisect = Bisector.bisect;
        descending = Sort.descending;
        ascending = Sort.ascending;
        ease = Easing.INSTANCE;
        color = Color.class;
        interpolators = Interpolators.INSTANCE;
        interpolate = Interpolate.INSTANCE;
        interpolateHcl = ColorInterpolation.HCLINSTANCE;
        interpolateHsl = ColorInterpolation.HSLINSTANCE;
        interpolateLab = ColorInterpolation.LABINSTANCE;
        interpolateRgb = ColorInterpolation.RGBINSTANCE;
        interpolateString = StringInterpolation.INSTANCE;
        interpolateNumber = NumberInterpolation.INSTANCE;
        interpolateRound = RoundInterpolation.INSTANCE;
        interpolateArray = ArrayInterpolation.INSTANCE;
        interpolateObject = ObjectInterpolation.INSTANCE;
        interpolateTransform = TransformInterpolation.INSTANCE;
        interpolateZoom = ZoomInterpolation.INSTANCE;
        xhr = XhrIdentity.INSTANCE;
        text = XhrText.INSTANCE;
        json = XhrJson.INSTANCE;
        html = XhrHtml.INSTANCE;
        xml = XhrXml.INSTANCE;
        dsv = DsvFactory.INSTANCE;
        csv = Csv.INSTANCE;
        tsv = Tsv.INSTANCE;
        map = new MapFunctionClass();
    }
}

