/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.arrays;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.arrays.Sort;
import com.ibm.vida.rave.core.functions.DoubleValueFunction;
import com.ibm.vida.rave.core.util.Comparator;
import java.util.List;

public final class Bisector<T> {
    private static final Bisector<Object> bisector = new Bisector<Object>(Sort.ascending);
    public static final BisectorFunction<Object> bisectLeft = Bisector.bisector.left;
    public static final BisectorFunction<Object> bisectRight = Bisector.bisector.right;
    public static final BisectorFunction<Object> bisect = Bisector.bisector.right;
    public final BisectorFunction<T> left;
    public final BisectorFunction<T> right;

    public Bisector(final Comparator<T> comparator) {
        this.left = new BisectorFunction<T>(){

            @Override
            public int bisect(List<T> a, T x, int lo, int hi) {
                int newLo = lo;
                int newHi = hi;
                while (newLo < newHi) {
                    int mid = newLo + newHi >>> 1;
                    if (comparator.compare(a.get(mid), x) < 0) {
                        newLo = mid + 1;
                        continue;
                    }
                    newHi = mid;
                }
                return newLo;
            }
        };
        this.right = new BisectorFunction<T>(){

            @Override
            public int bisect(List<T> a, T x, int lo, int hi) {
                int newLo = lo;
                int newHi = hi;
                while (newLo < newHi) {
                    int mid = newLo + newHi >>> 1;
                    if (comparator.compare(a.get(mid), x) > 0) {
                        newHi = mid;
                        continue;
                    }
                    newLo = mid + 1;
                }
                return newLo;
            }
        };
    }

    public static <T> Bisector<T> create(Comparator<T> comparator) {
        return new Bisector<T>(comparator);
    }

    public static <T> Bisector<T> create(final DoubleValueFunction<T> f) {
        return new Bisector<T>(new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return Sort.ascending.compare(f.getValue(a), b);
            }
        });
    }

    @FunctionClass(value="bisect")
    public static abstract class BisectorFunction<T> {
        public int bisect(List<T> a, T x) {
            return this.bisect(a, x, 0, a.size());
        }

        public int bisect(List<T> a, T x, int lo) {
            return this.bisect(a, x, lo, a.size());
        }

        public abstract int bisect(List<T> var1, T var2, int var3, int var4);
    }
}

