/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.arrays;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class Range {
    private Range() {
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> create(Object stop) {
        return Range.createRange(0.0, ObjectConverter.toDouble(stop), 1.0);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> create(Object start, Object stop) {
        return Range.createRange(ObjectConverter.toDouble(start), ObjectConverter.toDouble(stop), 1.0);
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public static ArrayEx<Number> create(Object start, Object stop, Object step) {
        return Range.createRange(ObjectConverter.toDouble(start), ObjectConverter.toDouble(stop), ObjectConverter.toDouble(step));
    }

    private static ArrayEx<Number> createRange(double start, double stop, double step) {
        double _start = start;
        double _stop = stop;
        double _step = step;
        ArrayEx<Number> range = new ArrayEx<Number>();
        if ((_stop - _start) / _step == Double.POSITIVE_INFINITY) {
            throw new RuntimeException("infinite range");
        }
        double k = Range.integerScale(Math.abs(_step));
        int i = -1;
        _start *= k;
        _stop *= k;
        if ((_step *= k) < 0.0) {
            while (true) {
                double d;
                double j = _start + _step * (double)(++i);
                if (d > _stop) {
                    range.add(j / k);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                double d;
                double j = _start + _step * (double)(++i);
                if (!(d < _stop)) break;
                range.add(j / k);
            }
        }
        return range;
    }

    private static double integerScale(double x) {
        double k = 1.0;
        while (ObjectConverter.toBoolean(x * k % 1.0)) {
            k *= 10.0;
        }
        return k;
    }
}

