/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.arrays;

import com.ibm.vida.rave.core.arrays.MinMax;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public class Zip {
    private static ValueFunction<List<?>, Integer> MIN_FN = new ValueFunction<List<?>, Integer>(){

        @Override
        public Integer getValue(List<?> context, Object data, int index, int groupIndex) {
            return ((List)data).size();
        }
    };

    private Zip() {
    }

    public static <T> ArrayEx<ArrayEx<T>> zip(List<T> ... objects) {
        int n = objects.length;
        ArrayEx<ArrayEx<T>> zips = new ArrayEx<ArrayEx<T>>();
        if (n == 0) {
            return zips;
        }
        int m = (int)ObjectConverter.toDouble(MinMax.min(Zip.toArrayEx(objects), MIN_FN));
        for (int i = 0; i < m; ++i) {
            ArrayEx<T> zip = new ArrayEx<T>(n);
            zips.add(zip);
            for (int j = 0; j < n; ++j) {
                zip.set(j, objects[j].get(i));
            }
        }
        return zips;
    }

    private static List<List<?>> toArrayEx(List<?>[] objects) {
        ArrayEx retVal = new ArrayEx();
        for (int index = 0; index < objects.length; ++index) {
            retVal.add(objects[index]);
        }
        return retVal;
    }
}

