/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.behavior;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.JsonObject;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.event.BaseEvent;
import com.ibm.vida.rave.core.event.Event;
import com.ibm.vida.rave.core.event.Touch;
import com.ibm.vida.rave.core.event.TouchEvent;
import com.ibm.vida.rave.core.event.TouchUtil;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.internal.event.CustomDispatcher;
import com.ibm.vida.rave.core.internal.nativeImpl.PlatformInitialization;
import com.ibm.vida.rave.core.internal.nativeImpl.event.DragSuppress;
import com.ibm.vida.rave.core.internal.util.Identity;
import com.ibm.vida.rave.core.nativeImpl.event.EventTracker;
import com.ibm.vida.rave.core.nativeImpl.event.Mouse;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.SelectorEventListener;
import com.ibm.vida.rave.core.selector.ValueFunction;

public final class Drag
implements RunFunction<Object> {
    @SwiftWeak(value=false)
    private final CustomDispatcher<EventObject, Drag, SceneNode> event = CustomDispatcher.create(this, "drag", "dragstart", "dragend");
    private ValueFunction<? super SceneNode, Origin> originFunc;
    private final ValueFunction<Object, SceneNode> rave_window = new ValueFunction<Object, SceneNode>(){

        @Override
        public SceneNode getValue(Object context, Object data, int index, int groupIndex) {
            return PlatformInitialization.getWindow((SceneNode)data);
        }
    };
    private final ValueFunction<Object, SceneNode> identity = Identity.create();
    private final GetId dragTouchId = new GetId(){

        @Override
        public String get() {
            return ((Touch)((TouchEvent)EventTracker.INSTANCE.get()).changedTouches.get((int)0)).identifier;
        }
    };
    private final SelectorEventListener<?> mousedowned = this.dragStart(null, new GetPosition(){

        @Override
        public Point get(SceneNode node, String id) {
            return Mouse.mousePoint(node);
        }
    }, this.rave_window, "mousemove", "mouseup");
    private final SelectorEventListener<?> touchstart = this.dragStart(this.dragTouchId, new GetPosition(){

        @Override
        public Point get(SceneNode node, String id) {
            return TouchUtil.touchFromSource(node, id);
        }
    }, this.identity, "touchmove", "touchend");

    @Override
    public Object run(Object context, Object ... args) {
        if (args == null || args.length == 0) {
            return this;
        }
        this.drag((Selector)args[0]);
        return null;
    }

    public void drag(Selector g) {
        g.on("mousedown.drag", this.mousedowned).on("touchstart.drag", this.touchstart);
    }

    private SelectorEventListener<Event> dragStart(final GetId id, final GetPosition position, final ValueFunction<Object, SceneNode> subject, final String move, final String end) {
        final Drag self = this;
        return new SelectorEventListener<Event>(){

            @Override
            public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                final Object target = EventTracker.INSTANCE.get().target;
                final SceneNode parent = context.getParentNode();
                final CustomDispatcher.DispatchContext dispatch = self.event.of(context, data, index, groupIndex);
                final int[] dragged = new int[]{0};
                final String dragId = id != null ? id.get() : null;
                final String dragName = ".drag" + (dragId == null ? "" : "-" + dragId);
                final Point[] dragOffset = new Point[1];
                final Selector dragSubject = Rave.select((SceneNode)subject.getValue(context, target, index, groupIndex));
                final DragSuppress.Suppress dragRestore = DragSuppress.dragSuppress(target);
                final Point[] position0 = new Point[]{position.get(parent, dragId)};
                if (self.originFunc != null) {
                    Origin value = (Origin)self.originFunc.getValue(context, data, index, groupIndex);
                    dragOffset[0] = new Point(value.x - position0[0].getX(), value.y - position0[0].getY());
                } else {
                    dragOffset[0] = new Point(0.0, 0.0);
                }
                dispatch.dispatch(new EventObject("dragstart", 0.0, 0.0, 0.0, 0.0));
                SelectorEventListener<Event> moved = new SelectorEventListener<Event>(){

                    @Override
                    public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                        Point position1 = position.get(parent, dragId);
                        if (position1 == null) {
                            return;
                        }
                        double dx = position1.getX() - position0[0].getX();
                        double dy = position1.getY() - position0[0].getY();
                        dragged[0] = dragged[0] | ((int)dx | (int)dy);
                        position0[0] = position1;
                        dispatch.dispatch(new EventObject("drag", position1.getX() + dragOffset[0].getX(), position1.getY() + dragOffset[0].getY(), dx, dy));
                    }
                };
                SelectorEventListener<Event> ended = new SelectorEventListener<Event>(){

                    @Override
                    public void onEvent(SceneNode context, Object data, int index, int groupIndex, Event event) {
                        if (position.get(parent, dragId) == null) {
                            return;
                        }
                        dragSubject.on(move + dragName, null).on(end + dragName, null);
                        dragRestore.suppress(dragged[0] != 0 && EventTracker.INSTANCE.get().target == target);
                        dispatch.dispatch(new EventObject("dragend", 0.0, 0.0, 0.0, 0.0));
                    }
                };
                dragSubject.on(move + dragName, (SelectorEventListener<? extends Event>)moved).on(end + dragName, (SelectorEventListener<? extends Event>)ended);
            }
        };
    }

    public ValueFunction<? super SceneNode, Origin> origin() {
        return this.originFunc;
    }

    public Drag origin(ValueFunction<? super SceneNode, Origin> x) {
        this.originFunc = x;
        return this;
    }

    public RunFunction<? super SceneNode> on(String type) {
        return this.event.on(type);
    }

    public Drag on(String type, RunFunction<? super SceneNode> listener) {
        this.event.on(type, listener);
        return this;
    }

    public static class EventObject
    extends BaseEvent<Drag> {
        public final double x;
        public final double y;
        public final double dx;
        public final double dy;

        EventObject(String type, double x, double y, double dx, double dy) {
            super(type);
            this.x = x;
            this.y = y;
            this.dx = dx;
            this.dy = dy;
        }
    }

    @JsonObject
    public static class Origin {
        public double x;
        public double y;
    }

    @FunctionClass(value="get")
    @SwiftClosure(value="get")
    private static interface GetPosition {
        public Point get(SceneNode var1, String var2);
    }

    @FunctionClass(value="get")
    @SwiftClosure(value="get")
    private static interface GetId {
        public String get();
    }
}

