/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.behavior;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.event.UIEvent;
import com.ibm.vida.rave.core.scene.SceneNode;

public final class FocusEventHandler {
    @InlineStringConstant
    public static final String FOCUS_EVENT_TYPE = "ravefocus";
    @InlineStringConstant
    public static final String BLUR_EVENT_TYPE = "raveblur";
    private SceneNode focusedNode;

    public SceneNode focused() {
        return this.focusedNode;
    }

    public void focused(SceneNode node) {
        this.focusedNode = node;
    }

    public boolean isFocused(SceneNode node) {
        return this.focusedNode != null ? this.focusedNode == node : false;
    }

    public void fireFocus(SceneNode node) {
        if (!this.isFocused(node)) {
            if (this.focusedNode != null) {
                this.focusedNode.dispatchEvent(FocusEventHandler.createEvent(BLUR_EVENT_TYPE));
            }
            this.focusedNode = node;
            node.dispatchEvent(FocusEventHandler.createEvent(FOCUS_EVENT_TYPE));
        }
    }

    public void fireBlur(SceneNode node) {
        if (this.isFocused(node)) {
            this.focusedNode = null;
            node.dispatchEvent(FocusEventHandler.createEvent(BLUR_EVENT_TYPE));
        }
    }

    private static final UIEvent createEvent(String type) {
        return new UIEvent(type, true, false);
    }
}

