/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.behavior;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.event.SelectionEvent;
import com.ibm.vida.rave.core.scene.SceneNode;
import java.util.ArrayList;
import java.util.List;

public final class SelectionEventHandler {
    @InlineStringConstant
    public static final String SELECTED_EVENT_TYPE = "raveselected";
    @InlineStringConstant
    public static final String UNSELECTED_EVENT_TYPE = "raveunselected";
    private ArrayEx<SceneNode> selectedNodes = new ArrayEx();

    public ArrayEx<SceneNode> selected() {
        return this.selectedNodes;
    }

    public void selected(SceneNode node) {
        this.selectedNodes.add(node);
    }

    public void selected(List<SceneNode> nodes) {
        for (SceneNode node : nodes) {
            this.selectedNodes.add(node);
        }
    }

    public SceneNode lastSelected() {
        return this.selectedNodes.size() > 0 ? (SceneNode)this.selectedNodes.get(this.selectedNodes.size() - 1) : null;
    }

    public boolean isSelected(SceneNode node) {
        return this.selectedNodes.indexOf(node) != -1;
    }

    public void fireSelected(SceneNode node) {
        this.fireSelected(node, true);
    }

    public void fireSelected(SceneNode node, boolean unselectPrevious) {
        ArrayList<EventContainer> events = new ArrayList<EventContainer>();
        int idx = -1;
        if (unselectPrevious) {
            SceneNode selectednode;
            while (this.selectedNodes.size() > 0 && (selectednode = this.selectedNodes.shift()) != null) {
                if (selectednode == node) {
                    idx = 0;
                    continue;
                }
                events.add(SelectionEventHandler.createEventContainer(UNSELECTED_EVENT_TYPE, selectednode, false, true));
            }
        } else {
            idx = this.selectedNodes.indexOf(node);
            if (idx >= 0) {
                this.selectedNodes.remove(idx);
            }
        }
        this.selectedNodes.add(node);
        events.add(SelectionEventHandler.createEventContainer(SELECTED_EVENT_TYPE, node, true, idx >= 0));
        this.fireEvents(events);
    }

    public void fireUnselectAll() {
        ArrayList<EventContainer> events = new ArrayList<EventContainer>();
        for (int i = 0; i < this.selectedNodes.size(); ++i) {
            events.add(SelectionEventHandler.createEventContainer(UNSELECTED_EVENT_TYPE, (SceneNode)this.selectedNodes.get(i), false, true));
        }
        this.selectedNodes = new ArrayEx();
        this.fireEvents(events);
    }

    public void fireSelected(List<SceneNode> nodes) {
        this.fireSelected(nodes, true);
    }

    public void fireSelected(List<SceneNode> nodes, boolean unselectPrevious) {
        ArrayEx<EventContainer> events = new ArrayEx<EventContainer>();
        if (unselectPrevious) {
            int i;
            ArrayList<EventContainer> selectedEvents = new ArrayList<EventContainer>();
            for (i = 0; i < nodes.size(); ++i) {
                SceneNode node;
                selectedEvents.add(SelectionEventHandler.createEventContainer(SELECTED_EVENT_TYPE, node, true, this.selectedNodes.indexOf(node = nodes.get(i)) >= 0));
            }
            for (i = 0; i < this.selectedNodes.size(); ++i) {
                SceneNode selectednode = (SceneNode)this.selectedNodes.get(i);
                if (nodes.indexOf(selectednode) < 0) continue;
                this.selectedNodes.remove(i--);
                events.add(SelectionEventHandler.createEventContainer(UNSELECTED_EVENT_TYPE, selectednode, false, true));
                break;
            }
            events = events.concat(selectedEvents);
        } else {
            for (int i = 0; i < nodes.size(); ++i) {
                SceneNode node;
                int idx = this.selectedNodes.indexOf(node = nodes.get(i));
                events.add(SelectionEventHandler.createEventContainer(SELECTED_EVENT_TYPE, node, true, idx >= 0));
                this.selectedNodes.remove(idx);
            }
            this.selectedNodes = this.selectedNodes.concat(nodes);
        }
        this.fireEvents(events);
    }

    public void fireUnselected(SceneNode node) {
        int idx = this.selectedNodes.indexOf(node);
        if (idx >= 0) {
            this.selectedNodes.remove(idx);
            node.dispatchEvent(SelectionEventHandler.createEvent(UNSELECTED_EVENT_TYPE, false, true));
        }
    }

    public void fireUnselected(List<SceneNode> nodes) {
        ArrayList<EventContainer> events = new ArrayList<EventContainer>();
        block0: for (int i = 0; i < this.selectedNodes.size(); ++i) {
            for (int j = 0; j < nodes.size(); ++j) {
                SceneNode selectednode = (SceneNode)this.selectedNodes.get(i);
                if (nodes.get(j) != selectednode) continue;
                this.selectedNodes.remove(i--);
                events.add(SelectionEventHandler.createEventContainer(UNSELECTED_EVENT_TYPE, selectednode, false, true));
                continue block0;
            }
        }
        this.fireEvents(events);
    }

    private void fireEvents(List<EventContainer> events) {
        ArrayEx<SceneNode> clone = this.selectedNodes.slice();
        for (EventContainer e : events) {
            e.event.selection = clone;
            e.target.dispatchEvent(e.event);
        }
    }

    private static final SelectionEvent createEvent(String type, boolean selected, boolean previouslySelected) {
        SelectionEvent event = new SelectionEvent(type, true, false);
        event.selected = selected;
        event.previouslySelected = previouslySelected;
        return event;
    }

    private static final EventContainer createEventContainer(String type, SceneNode target, boolean selected, boolean previouslySelected) {
        return new EventContainer(SelectionEventHandler.createEvent(type, selected, previouslySelected), target);
    }

    private static final class EventContainer {
        final SelectionEvent event;
        final SceneNode target;

        EventContainer(SelectionEvent event, SceneNode target) {
            this.event = event;
            this.target = target;
        }
    }
}

