/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.color;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.internal.color.ContrastShift;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class HSL
extends Color {
    final double h;
    final double s;
    final double l;
    final double a;

    HSL(double h, double s, double l, double a) {
        this.h = ObjectConverter.toDouble(h);
        this.s = ObjectConverter.toDouble(s);
        this.l = ObjectConverter.toDouble(l);
        this.a = ObjectConverter.toDouble(a);
    }

    @Override
    public RGB rgb() {
        return Colors.hsl_rgb(this.h, this.s, this.l, this.a);
    }

    @Override
    public Color brighter(double k) {
        double _k = Math.pow(0.7, k);
        return new HSL(this.h, this.s, this.l / _k, this.a);
    }

    @Override
    public Color darker(double k) {
        double _k = Math.pow(0.7, k);
        return new HSL(this.h, this.s, _k * this.l, this.a);
    }

    public double getH() {
        return this.h;
    }

    public double getS() {
        return this.s;
    }

    public double getL() {
        return this.l;
    }

    public double getA() {
        return this.a;
    }

    @Override
    public Color contrastShift() {
        return ContrastShift.updateColor(this.rgb(), this.rgb()).hsl();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color)).hsl();
    }

    @Override
    public Color contrastShift(double ratio) {
        return ContrastShift.updateColor(this.rgb(), this.rgb(), ratio).hsl();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color, double ratio) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color), ratio).hsl();
    }

    @Override
    public double getLuminance() {
        return ContrastShift.getLuminance(this.rgb());
    }
}

