/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.color;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.HCL;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.internal.color.ContrastShift;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class LAB
extends Color {
    final double l;
    final double a;
    final double b;

    LAB(double l, double a, double b) {
        this.l = ObjectConverter.toDouble(l);
        this.a = ObjectConverter.toDouble(a);
        this.b = ObjectConverter.toDouble(b);
    }

    @Override
    public RGB rgb() {
        return Colors.lab_rgb(this.l, this.a, this.b);
    }

    @Override
    public Color brighter(double k) {
        return new LAB(Math.min(100.0, this.l + Colors.lab_K * k), this.a, this.b);
    }

    @Override
    public Color darker(double k) {
        return new LAB(Math.max(0.0, this.l - Colors.lab_K * k), this.a, this.b);
    }

    HCL hcl() {
        return Colors.lab_hcl(this.l, this.a, this.b);
    }

    public double getL() {
        return this.l;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    @Override
    public Color contrastShift() {
        return ContrastShift.updateColor(this.rgb(), this.rgb()).lab();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color)).lab();
    }

    @Override
    public Color contrastShift(double ratio) {
        return ContrastShift.updateColor(this.rgb(), this.rgb(), ratio).lab();
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color, double ratio) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color), ratio).lab();
    }

    @Override
    public double getLuminance() {
        return ContrastShift.getLuminance(this.rgb());
    }
}

