/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.color;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.Colors;
import com.ibm.vida.rave.core.color.HSL;
import com.ibm.vida.rave.core.color.LAB;
import com.ibm.vida.rave.core.internal.color.ContrastShift;

public class RGB
extends Color {
    final int r;
    final int g;
    final int b;
    final double a;

    RGB(int r, int g, int b, double a) {
        this.r = ~(~r);
        this.g = ~(~g);
        this.b = ~(~b);
        this.a = a;
    }

    @Override
    public RGB rgb() {
        return this;
    }

    public HSL hsl() {
        return Colors.rgb_hsl(this.r, this.g, this.b, this.a);
    }

    LAB lab() {
        return Colors.rgb_lab(this.r, this.g, this.b);
    }

    @Override
    public Color brighter(double k) {
        int r = this.r;
        int g = this.g;
        int b = this.b;
        int i = 30;
        if (r == 0 && g == 0 && b == 0) {
            return new RGB(i, i, i, this.a);
        }
        if (r != 0 && r < i) {
            r = i;
        }
        if (g != 0 && g < i) {
            g = i;
        }
        if (b != 0 && b < i) {
            b = i;
        }
        double _k = Math.pow(0.7, k);
        return new RGB((int)Math.min(255.0, (double)r / _k), (int)Math.min(255.0, (double)g / _k), (int)Math.min(255.0, (double)b / _k), this.a);
    }

    @Override
    public Color darker(double k) {
        double _k = Math.pow(0.7, k);
        return new RGB((int)(_k * (double)this.r), (int)(_k * (double)this.g), (int)(_k * (double)this.b), this.a);
    }

    @Override
    public String toString() {
        if (this.a != 1.0) {
            return "rgba(" + this.r + "," + this.g + "," + this.b + "," + this.a + ")";
        }
        return "#" + Colors.rgb_hex(this.r) + Colors.rgb_hex(this.g) + Colors.rgb_hex(this.b);
    }

    public final int getR() {
        return this.r;
    }

    public final int getG() {
        return this.g;
    }

    public final int getB() {
        return this.b;
    }

    public final double getA() {
        return this.a;
    }

    @Override
    public Color contrastShift() {
        return ContrastShift.updateColor(this.rgb(), this.rgb());
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color));
    }

    @Override
    public Color contrastShift(double ratio) {
        return ContrastShift.updateColor(this.rgb(), this.rgb(), ratio);
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public Color contrastShift(Object color, double ratio) {
        return ContrastShift.updateColor(this.rgb(), Colors.newRGB(color), ratio);
    }

    @Override
    public double getLuminance() {
        return ContrastShift.getLuminance(this.rgb());
    }
}

