/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.ease;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.ease.EasingFunction;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

@FunctionClass(value="ease")
public final class Easing {
    public static final Easing INSTANCE = new Easing();
    private static final double HALF_PI = 1.5707963267948966;
    private static final double PI_2 = Math.PI * 2;
    private static EasingFunction identity = new EasingFunction(){

        @Override
        public double ease(double t) {
            return t;
        }
    };
    private static EasingFunction quad = new EasingFunction(){

        @Override
        public double ease(double t) {
            return t * t;
        }
    };
    private static EasingFunction cubic = new EasingFunction(){

        @Override
        public double ease(double t) {
            return t * t * t;
        }
    };
    private static EasingFunction cubicInOut = new EasingFunction(){

        @Override
        public double ease(double t) {
            if (t <= 0.0) {
                return 0.0;
            }
            if (t >= 1.0) {
                return 1.0;
            }
            double t2 = t * t;
            double t3 = t2 * t;
            return 4.0 * (t < 0.5 ? t3 : 3.0 * (t - t2) + t3 - 0.75);
        }
    };
    private static EasingFunction sin = new EasingFunction(){

        @Override
        public double ease(double t) {
            return 1.0 - Math.cos(t * 1.5707963267948966);
        }
    };
    private static EasingFunction exp = new EasingFunction(){

        @Override
        public double ease(double t) {
            return Math.pow(2.0, 10.0 * (t - 1.0));
        }
    };
    private static EasingFunction circle = new EasingFunction(){

        @Override
        public double ease(double t) {
            return 1.0 - Math.sqrt(1.0 - t * t);
        }
    };
    private static EasingFunction bounce = new EasingFunction(){

        @Override
        public double ease(double t) {
            double _t = t;
            return _t < 0.36363636363636365 ? 7.5625 * _t * _t : (_t < 0.7272727272727273 ? 7.5625 * (_t -= 0.5454545454545454) * _t + 0.75 : (_t < 0.9090909090909091 ? 7.5625 * (_t -= 0.8181818181818182) * _t + 0.9375 : 7.5625 * (_t -= 0.9545454545454546) * _t + 0.984375));
        }
    };
    public static final EasingFunction DEFAULT = cubicInOut;

    private Easing() {
    }

    public EasingFunction ease(String type, Object ... args) {
        int i = type.indexOf("-");
        String t = i >= 0 ? type.substring(0, i) : type;
        String m = i >= 0 ? type.substring(i + 1) : "in";
        EasingFunction e = identity;
        if ("poly".equals(t)) {
            e = Easing.poly(ObjectConverter.asDouble(args[0]));
        } else if ("quad".equals(t)) {
            e = quad;
        } else if ("cubic".equals(t)) {
            e = cubic;
        } else if ("sin".equals(t)) {
            e = sin;
        } else if ("exp".equals(t)) {
            e = exp;
        } else if ("circle".equals(t)) {
            e = circle;
        } else if ("elastic".equals(t)) {
            if (args == null || args.length == 0) {
                e = Easing.elastic();
            } else if (args.length == 1) {
                e = Easing.elastic(ObjectConverter.asDouble(args[0]));
            } else if (args.length == 2) {
                e = Easing.elastic(ObjectConverter.asDouble(args[0]), ObjectConverter.asDouble(args[1]));
            }
        } else if ("back".equals(t)) {
            if (args == null || args.length == 0) {
                e = Easing.back();
            } else if (args.length == 1) {
                e = Easing.back(ObjectConverter.asDouble(args[0]));
            }
        } else if ("bounce".equals(t)) {
            e = bounce;
        }
        if ("out".equals(m)) {
            e = Easing.reverse(e);
        } else if ("in-out".equals(m)) {
            e = Easing.reflect(e);
        } else if ("out-in".equals(m)) {
            e = Easing.reflect(Easing.reverse(e));
        }
        return Easing.clamp(e);
    }

    private static EasingFunction clamp(final EasingFunction f) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return t <= 0.0 ? 0.0 : (t >= 1.0 ? 1.0 : f.ease(t));
            }
        };
    }

    private static EasingFunction reverse(final EasingFunction f) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return 1.0 - f.ease(1.0 - t);
            }
        };
    }

    private static EasingFunction reflect(final EasingFunction f) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return 0.5 * (t < 0.5 ? f.ease(2.0 * t) : 2.0 - f.ease(2.0 - 2.0 * t));
            }
        };
    }

    private static EasingFunction poly(final double e) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return Math.pow(t, e);
            }
        };
    }

    private static EasingFunction elastic() {
        return Easing.elastic(1.0, 0.45, 0.1125);
    }

    private static EasingFunction elastic(double a) {
        return Easing.elastic(a, 0.45);
    }

    private static EasingFunction elastic(double a, double p) {
        return Easing.elastic(a, p, p / (Math.PI * 2) * Math.asin(1.0 / a));
    }

    private static EasingFunction elastic(final double a, final double p, final double s) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return 1.0 + a * Math.pow(2.0, -10.0 * t) * Math.sin((t - s) * (Math.PI * 2) / p);
            }
        };
    }

    private static EasingFunction back() {
        return Easing.back(1.70158);
    }

    private static EasingFunction back(final double s) {
        return new EasingFunction(){

            @Override
            public double ease(double t) {
                return t * t * ((s + 1.0) * t - s);
            }
        };
    }
}

