/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.event;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftWeak;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.selector.RunFunction;

public class Dispatcher<C>
extends OMap<String, DispatcherEvent<C>> {
    public static <C> Dispatcher<C> create(String ... types) {
        Dispatcher<C> dispatch = new Dispatcher<C>();
        dispatch.init(types);
        return dispatch;
    }

    protected void init(String ... types) {
        int i = -1;
        int n = types.length;
        while (++i < n) {
            this.put(types[i], Dispatcher.createEvent(this));
        }
    }

    private static <C> DispatcherEvent<C> createEvent(final @SwiftWeak Dispatcher<C> dispatch) {
        final ArrayEx[] listeners = new ArrayEx[]{new ArrayEx()};
        final OMap[] listenerByName = new OMap[]{new OMap()};
        return new DispatcherEvent<C>(){

            @Override
            public Dispatcher<C> fire(C context, Object ... args) {
                ArrayEx z = listeners[0];
                int i = -1;
                int n = z.size();
                while (++i < n) {
                    ListenerWrapper l = (ListenerWrapper)z.get(i);
                    if (l.on == null) continue;
                    l.on.run(context, args);
                }
                return dispatch;
            }

            @Override
            public RunFunction<? super C> on(String name) {
                ListenerWrapper l = (ListenerWrapper)listenerByName[0].get(name);
                return l != null && l.on != null ? l.on : null;
            }

            @Override
            public Dispatcher<C> on(String name, RunFunction<? super C> listener) {
                ListenerWrapper l = (ListenerWrapper)listenerByName[0].get(name);
                if (l != null) {
                    l.on = null;
                    int i = listeners[0].indexOf(l);
                    listeners[0] = listeners[0].slice(0, i).concat(listeners[0].slice(i + 1));
                    listenerByName[0].remove(name);
                }
                if (listener != null) {
                    l = new ListenerWrapper(listener);
                    listenerByName[0].put(name, l);
                    listeners[0].add(l);
                }
                return dispatch;
            }
        };
    }

    protected Dispatcher() {
    }

    public RunFunction<? super C> on(String type) {
        String t = type;
        int i = t.indexOf(".");
        String name = "";
        if (i >= 0) {
            name = t.substring(i + 1);
            t = t.substring(0, i);
        }
        if (t.length() > 0) {
            return ((DispatcherEvent)this.get(t)).on(name);
        }
        return (RunFunction)Lang.undefined();
    }

    public Dispatcher<C> on(String type, RunFunction<? super C> listener) {
        String t = type;
        int i = t.indexOf(".");
        String name = "";
        if (i >= 0) {
            name = t.substring(i + 1);
            t = t.substring(0, i);
        }
        if (t.length() > 0) {
            return ((DispatcherEvent)this.get(t)).on(name, listener);
        }
        if (listener == null) {
            for (String key : this.keySet()) {
                if (!this.containsKey(key)) continue;
                ((DispatcherEvent)this.get(key)).on(name, null);
            }
        }
        return this;
    }

    @FunctionClass(value="fire", contextInvocation=true)
    public static interface DispatcherEvent<C> {
        public Dispatcher<C> fire(C var1, Object ... var2);

        public RunFunction<? super C> on(String var1);

        public Dispatcher<C> on(String var1, RunFunction<? super C> var2);
    }

    private static class ListenerWrapper<C> {
        RunFunction<? super C> on;

        ListenerWrapper(RunFunction<? super C> on) {
            this.on = on;
        }
    }
}

