/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.geo;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.geo.InvertiblePointProjector;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.geo.GeoInterpolator;
import com.ibm.vida.rave.core.internal.geo.GeoShapeGeneratorUtil;
import com.ibm.vida.rave.core.internal.geo.SphericalRotation;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

@FunctionClass(value="generate")
public final class CircleShapeGenerator {
    private static final double[] DEFAULT_ORIGIN = new double[]{0.0, 0.0};
    private double precisionValue;
    private double angleValue;
    private Object originObject;
    private GeoInterpolator interpolator;

    private CircleShapeGenerator() {
    }

    static CircleShapeGenerator newCircleShapeGenerator() {
        CircleShapeGenerator circle = new CircleShapeGenerator();
        circle.precisionValue = 6.0;
        circle.originObject = DEFAULT_ORIGIN;
        circle.angle(90);
        return circle;
    }

    public Object origin() {
        return this.originObject;
    }

    public CircleShapeGenerator origin(double[] originPoint) {
        this.originObject = originPoint;
        return this;
    }

    public CircleShapeGenerator origin(ValueFunction originFn) {
        this.originObject = originFn;
        return this;
    }

    public double angle() {
        return this.angleValue;
    }

    @SwiftMethodOverload(skipOverloads={"Bool"})
    public CircleShapeGenerator angle(Object x) {
        this.angleValue = ObjectConverter.toDouble(x);
        this.interpolator = GeoShapeGeneratorUtil.newCircleInterpolator(this.angleValue * (Math.PI / 180), this.precisionValue * (Math.PI / 180));
        return this;
    }

    public double precision() {
        return this.precisionValue;
    }

    public CircleShapeGenerator precision(double x) {
        this.precisionValue = ObjectConverter.toDouble(x);
        this.interpolator = GeoShapeGeneratorUtil.newCircleInterpolator(this.angleValue * (Math.PI / 180), this.precisionValue * (Math.PI / 180));
        return this;
    }

    public JSONObject generate(Object ... originArgs) {
        double[] center = this.originObject instanceof ValueFunction ? ((ValueFunction)this.originObject).getValue(originArgs) : (double[])this.originObject;
        final InvertiblePointProjector rotate = SphericalRotation.rotation(-center[0] * (Math.PI / 180), -center[1] * (Math.PI / 180), 0.0);
        final JSONArray ring = new JSONArray();
        JSONArray coordinates = new JSONArray();
        coordinates.add((Object)ring);
        DelegatingStreamListener listener = new DelegatingStreamListener();
        listener.setPointDelegate(new DelegatingStreamListener.StreamPointStateHandler(){

            @Override
            public void handle(double x, double y, double z) {
                double[] invertedPoint = rotate.invert(x, y);
                invertedPoint[0] = invertedPoint[0] * 57.29577951308232;
                invertedPoint[1] = invertedPoint[1] * 57.29577951308232;
                ring.add((Object)Lang.toJSONArray(Lang.toArray(Lang.asDouble(invertedPoint))));
            }
        });
        if (this.interpolator != null) {
            this.interpolator.interpolate(null, null, 1, listener);
        }
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"Polygon");
        json.put((Object)"coordinates", (Object)coordinates);
        return json;
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface ValueFunction {
        public double[] getValue(Object ... var1);
    }
}

