/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.geo;

import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.core.RegistryService;
import com.ibm.vida.rave.core.geo.CircleShapeGenerator;
import com.ibm.vida.rave.core.geo.ClipExtentStreamListenerTransform;
import com.ibm.vida.rave.core.geo.ConicProjection;
import com.ibm.vida.rave.core.geo.ConicProjectionFactory;
import com.ibm.vida.rave.core.geo.GeoPathGenerator;
import com.ibm.vida.rave.core.geo.GraticuleShapeGenerator;
import com.ibm.vida.rave.core.geo.GreatArcShapeGenerator;
import com.ibm.vida.rave.core.geo.InvertibleProjection;
import com.ibm.vida.rave.core.geo.PlaneProjectionFactory;
import com.ibm.vida.rave.core.geo.PointProjector;
import com.ibm.vida.rave.core.geo.PointProjectorFactory;
import com.ibm.vida.rave.core.geo.Projection;
import com.ibm.vida.rave.core.geo.ProjectionMutator;
import com.ibm.vida.rave.core.geo.SphericalRotator;
import com.ibm.vida.rave.core.geo.StreamListener;
import com.ibm.vida.rave.core.geo.TransformStreamListenerFactory;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.internal.geo.AlbersUsaProjection;
import com.ibm.vida.rave.core.internal.geo.ConicProjectionFactoryImpl;
import com.ibm.vida.rave.core.internal.geo.DelegatingStreamListener;
import com.ibm.vida.rave.core.internal.geo.GeoPathGeneratorImpl;
import com.ibm.vida.rave.core.internal.geo.MercatorPlaneProjectionFactory;
import com.ibm.vida.rave.core.internal.geo.PlaneProjectionFactoryImpl;
import com.ibm.vida.rave.core.internal.geo.ProjectionImpl;
import com.ibm.vida.rave.core.internal.geo.ProjectionMutatorImpl;
import com.ibm.vida.rave.core.internal.geo.SphericalArea;
import com.ibm.vida.rave.core.internal.geo.SphericalBounds;
import com.ibm.vida.rave.core.internal.geo.SphericalCentroid;
import com.ibm.vida.rave.core.internal.geo.SphericalInterpolation;
import com.ibm.vida.rave.core.internal.geo.SphericalLength;
import com.ibm.vida.rave.core.internal.geo.SphericalRotation;
import com.ibm.vida.rave.core.internal.geo.SphericalUtil;
import com.ibm.vida.rave.core.internal.geo.Stream;
import com.ibm.vida.rave.core.internal.geo.TransverseMercatorProjectionFactory;
import com.ibm.vida.rave.core.interpolate.Interpolator;

public final class Geo
extends RegistryService {
    public static final Geo INSTANCE = new Geo();
    public final PlaneProjectionFactory mercator = MercatorPlaneProjectionFactory.INSTANCE;
    public final PlaneProjectionFactory transverseMercator = TransverseMercatorProjectionFactory.INSTANCE;
    public final PlaneProjectionFactory azimuthalEqualArea = PlaneProjectionFactoryImpl.newAzimuthalEqualAreaProjectionFactory();
    public final PlaneProjectionFactory azimuthalEquidistant = PlaneProjectionFactoryImpl.newAzimuthalEquidistantProjectionFactory();
    public final ConicProjectionFactory conicEquidistant = ConicProjectionFactoryImpl.newConicEquidistantProjectionFactory();
    public final ConicProjectionFactory conicConformal = ConicProjectionFactoryImpl.newConicConformalProjectionFactory();
    public final ConicProjectionFactory conicEqualArea = ConicProjectionFactoryImpl.newConicEqualAreaProjectionFactory();
    public final PlaneProjectionFactory equirectangular = PlaneProjectionFactoryImpl.newEquirectangularProjectionFactory();
    public final PlaneProjectionFactory stereographic = PlaneProjectionFactoryImpl.newStereographicProjectionFactory();
    public final PlaneProjectionFactory orthographic = PlaneProjectionFactoryImpl.newOrthographicProjectionFactory();
    public final PlaneProjectionFactory gnomonic = PlaneProjectionFactoryImpl.newGnomonicProjectionFactory();
    public final PlaneProjectionFactory winkel3 = PlaneProjectionFactoryImpl.newWinkelTripelProjectionFactory();

    @Override
    public String getServiceId() {
        return "Geo";
    }

    private Geo() {
    }

    public void stream(JSONObject json, StreamListener listener) {
        Stream.INSTANCE.stream(json, listener);
    }

    public double area(JSONObject json) {
        SphericalArea sphericalArea = new SphericalArea();
        return sphericalArea.calculateArea(json);
    }

    public double[][] bounds(JSONObject feature) {
        SphericalBounds sphericalBounds = new SphericalBounds();
        return sphericalBounds.calculateBounds(feature);
    }

    public double[] centroid(JSONObject feature) {
        SphericalCentroid sphericalCentroid = new SphericalCentroid();
        return sphericalCentroid.calculateCentroid(feature);
    }

    public double distance(double[] a, double[] b) {
        return SphericalUtil.calculateDistance(a, b);
    }

    public double length(JSONObject feature) {
        SphericalLength sphericalLength = new SphericalLength();
        return sphericalLength.calculateLength(feature);
    }

    public Interpolator<double[]> interpolate(double[] source, double[] target) {
        return SphericalInterpolation.newInterpolator(source, target);
    }

    public SphericalRotator rotation(double[] location) {
        return SphericalRotation.newRotator(location);
    }

    public CircleShapeGenerator circle() {
        return CircleShapeGenerator.newCircleShapeGenerator();
    }

    @Deprecated
    public GreatArcShapeGenerator greatArc() {
        return GreatArcShapeGenerator.newGreatArcShapeGenerator();
    }

    public GraticuleShapeGenerator graticule() {
        return GraticuleShapeGenerator.newGraticuleShapeGenerator();
    }

    public TransformStreamListenerFactory transform(OMap<String, DelegatingStreamListener.BaseStreamStateHandler> delegates) {
        return TransformStreamListenerFactory.create(delegates);
    }

    public ClipExtentStreamListenerTransform clipExtent() {
        return ClipExtentStreamListenerTransform.newClipExtent();
    }

    public Projection projection(PointProjector projetor) {
        return ProjectionImpl.newProjection(projetor);
    }

    public ProjectionMutator projectionMutator(PointProjectorFactory projectorFactory) {
        return ProjectionMutatorImpl.newProjectionMutator(projectorFactory);
    }

    public ConicProjection albers() {
        return AlbersUsaProjection.newAlbersProjection();
    }

    public InvertibleProjection albersUsa() {
        return AlbersUsaProjection.newAlbersUsaProjection();
    }

    public GeoPathGenerator path() {
        return GeoPathGeneratorImpl.newGeoPathGenerator();
    }
}

