/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.geo;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.geo.GeoShapeGeneratorUtil;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

@FunctionClass(value="generate")
public final class GraticuleShapeGenerator {
    private double x1;
    private double x0;
    private double X1;
    private double X0;
    private double y1;
    private double y0;
    private double Y1;
    private double Y0;
    private double dx;
    private double dy;
    private double DX;
    private double DY;
    private double precisionValue;
    private GeoShapeGeneratorUtil.GraticuleValueFunction x;
    private GeoShapeGeneratorUtil.GraticuleValueFunction y;
    private GeoShapeGeneratorUtil.GraticuleValueFunction X;
    private GeoShapeGeneratorUtil.GraticuleValueFunction Y;

    private GraticuleShapeGenerator() {
    }

    static GraticuleShapeGenerator newGraticuleShapeGenerator() {
        GraticuleShapeGenerator graticule = new GraticuleShapeGenerator();
        graticule.dx = 10.0;
        graticule.dy = 10.0;
        graticule.DX = 90.0;
        graticule.DY = 360.0;
        graticule.precisionValue = 2.5;
        graticule.majorExtent(new ArrayEx(new ArrayEx<Double>(-180.0, -89.999999), new ArrayEx<Double>(180.0, 89.999999)));
        return graticule.minorExtent(new ArrayEx(new ArrayEx<Double>(-180.0, -80.000001), new ArrayEx<Double>(180.0, 80.000001)));
    }

    public JSONObject generate() {
        JSONArray coordinates = Lang.toJSONArray(this.generateLines());
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"MultiLineString");
        json.put((Object)"coordinates", (Object)coordinates);
        return json;
    }

    private ArrayEx<ArrayEx<ArrayEx<Number>>> generateLines() {
        final GraticuleShapeGenerator self = this;
        ArrayEx<ArrayEx<ArrayEx<Number>>> array_X = Rave.range(Math.ceil(this.X0 / this.DX) * this.DX, this.X1, this.DX).map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<ArrayEx<Number>>>(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return self.X.getValue(ObjectConverter.toDouble(currentValue));
            }
        });
        ArrayEx<ArrayEx<ArrayEx<Number>>> array_Y = Rave.range(Math.ceil(this.Y0 / this.DY) * this.DY, this.Y1, this.DY).map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<ArrayEx<Number>>>(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return self.Y.getValue(ObjectConverter.toDouble(currentValue));
            }
        });
        ArrayEx<ArrayEx<ArrayEx<Number>>> array_x = Rave.range(Math.ceil(this.x0 / this.dx) * this.dx, this.x1, this.dx).filter(new ArrayEx.ArrayValueFunction<Number, Boolean>(){

            @Override
            public Boolean getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return Math.abs(ObjectConverter.toDouble(currentValue) % self.DX) > 1.0E-6;
            }
        }).map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<ArrayEx<Number>>>(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return self.x.getValue(ObjectConverter.toDouble(currentValue));
            }
        });
        ArrayEx<ArrayEx<ArrayEx<Number>>> array_y = Rave.range(Math.ceil(this.y0 / this.dy) * this.dy, this.y1, this.dy).filter(new ArrayEx.ArrayValueFunction<Number, Boolean>(){

            @Override
            public Boolean getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return Math.abs(ObjectConverter.toDouble(currentValue) % self.DY) > 1.0E-6;
            }
        }).map(new ArrayEx.ArrayValueFunction<Number, ArrayEx<ArrayEx<Number>>>(){

            @Override
            public ArrayEx<ArrayEx<Number>> getValue(Number currentValue, int index, ArrayEx<Number> array) {
                return self.y.getValue(ObjectConverter.toDouble(currentValue));
            }
        });
        return array_X.concat(array_Y, array_x, array_y);
    }

    public ArrayEx<JSONObject> lines() {
        return this.generateLines().map(new ArrayEx.ArrayValueFunction<ArrayEx<ArrayEx<Number>>, JSONObject>(){

            @Override
            public JSONObject getValue(ArrayEx<ArrayEx<Number>> currentValue, int index, ArrayEx<ArrayEx<ArrayEx<Number>>> array) {
                JSONArray coordinates = Lang.toJSONArray(currentValue);
                JSONObject json = new JSONObject();
                json.put((Object)"type", (Object)"LineString");
                json.put((Object)"coordinates", (Object)coordinates);
                return json;
            }
        });
    }

    public JSONObject outline() {
        ArrayEx<ArrayEx<Number>> coords = this.X.getValue(this.X0).concat(this.Y.getValue(this.Y1).slice(1), this.X.getValue(this.X1).reverse().slice(1), this.Y.getValue(this.Y0).reverse().slice(1));
        JSONArray coordinates = new JSONArray();
        coordinates.add((Object)Lang.toJSONArray(coords));
        JSONObject json = new JSONObject();
        json.put((Object)"type", (Object)"Polygon");
        json.put((Object)"coordinates", (Object)coordinates);
        return json;
    }

    public ArrayEx<ArrayEx<Double>> extent() {
        return this.minorExtent();
    }

    public GraticuleShapeGenerator extent(ArrayEx<ArrayEx<?>> ext) {
        return this.majorExtent(ext).minorExtent(ext);
    }

    public ArrayEx<ArrayEx<Double>> majorExtent() {
        return new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>(this.X0, this.Y0), new ArrayEx<Double>(this.X1, this.Y1));
    }

    public GraticuleShapeGenerator majorExtent(ArrayEx<ArrayEx<?>> ext) {
        double temp;
        this.X0 = ObjectConverter.toDouble(((ArrayEx)ext.get(0)).get(0));
        this.X1 = ObjectConverter.toDouble(((ArrayEx)ext.get(1)).get(0));
        this.Y0 = ObjectConverter.toDouble(((ArrayEx)ext.get(0)).get(1));
        this.Y1 = ObjectConverter.toDouble(((ArrayEx)ext.get(1)).get(1));
        if (this.X0 > this.X1) {
            temp = this.X0;
            this.X0 = this.X1;
            this.X1 = temp;
        }
        if (this.Y0 > this.Y1) {
            temp = this.Y0;
            this.Y0 = this.Y1;
            this.Y1 = temp;
        }
        return this.precision(this.precisionValue);
    }

    public ArrayEx<ArrayEx<Double>> minorExtent() {
        return new ArrayEx<ArrayEx<Double>>(new ArrayEx<Double>(this.x0, this.y0), new ArrayEx<Double>(this.x1, this.y1));
    }

    public GraticuleShapeGenerator minorExtent(ArrayEx<ArrayEx<?>> ext) {
        double temp;
        this.x0 = ObjectConverter.toDouble(((ArrayEx)ext.get(0)).get(0));
        this.x1 = ObjectConverter.toDouble(((ArrayEx)ext.get(1)).get(0));
        this.y0 = ObjectConverter.toDouble(((ArrayEx)ext.get(0)).get(1));
        this.y1 = ObjectConverter.toDouble(((ArrayEx)ext.get(1)).get(1));
        if (this.x0 > this.x1) {
            temp = this.x0;
            this.x0 = this.x1;
            this.x1 = temp;
        }
        if (this.y0 > this.y1) {
            temp = this.y0;
            this.y0 = this.y1;
            this.y1 = temp;
        }
        return this.precision(this.precisionValue);
    }

    public ArrayEx<Double> step() {
        return this.minorStep();
    }

    public GraticuleShapeGenerator step(ArrayEx<?> s) {
        return this.majorStep(s).minorStep(s);
    }

    public ArrayEx<Double> majorStep() {
        return new ArrayEx<Double>(this.DX, this.DY);
    }

    public GraticuleShapeGenerator majorStep(ArrayEx<?> s) {
        this.DX = ObjectConverter.toDouble(s.get(0));
        this.DY = ObjectConverter.toDouble(s.get(1));
        return this;
    }

    public ArrayEx<Double> minorStep() {
        return new ArrayEx<Double>(this.dx, this.dy);
    }

    public GraticuleShapeGenerator minorStep(ArrayEx<?> s) {
        this.dx = ObjectConverter.toDouble(s.get(0));
        this.dy = ObjectConverter.toDouble(s.get(1));
        return this;
    }

    public double precision() {
        return this.precisionValue;
    }

    public GraticuleShapeGenerator precision(double p) {
        this.precisionValue = ObjectConverter.toDouble(p);
        this.x = GeoShapeGeneratorUtil.graticuleX(this.y0, this.y1, 90.0);
        this.y = GeoShapeGeneratorUtil.graticuleY(this.x0, this.x1, this.precisionValue);
        this.X = GeoShapeGeneratorUtil.graticuleX(this.Y0, this.Y1, 90.0);
        this.Y = GeoShapeGeneratorUtil.graticuleY(this.X0, this.X1, this.precisionValue);
        return this;
    }
}

