/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.geom;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.geom.Line;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class ClipLine {
    private static PointCreator DEFAULT_POINT_CREATOR = new PointCreator(){

        @Override
        public PointStruct apply(double x, double y) {
            return new PointStruct(x, y);
        }
    };

    public static LineClipper create(double x0, double y0, double x1, double y1) {
        return new InnerClipper(x0, y0, x1, y1);
    }

    public static LineClipper create(double x0, double y0, double x1, double y1, PointCreator creator) {
        InnerClipper clipper = new InnerClipper(x0, y0, x1, y1);
        clipper.pointCreator = creator;
        return clipper;
    }

    static /* synthetic */ PointCreator access$100() {
        return DEFAULT_POINT_CREATOR;
    }

    private static class InnerClipper
    implements LineClipper {
        private final double x0;
        private final double y0;
        private final double x1;
        private final double y1;
        private PointCreator pointCreator = ClipLine.access$100();

        InnerClipper(double x0, double y0, double x1, double y1) {
            this.x0 = x0;
            this.y0 = y0;
            this.x1 = x1;
            this.y1 = y1;
        }

        @Override
        public Line clip(Line line) {
            PointStruct a = line.getA();
            PointStruct b = line.getB();
            double ax = a.x;
            double ay = a.y;
            double bx = b.x;
            double by = b.y;
            double t0 = 0.0;
            double t1 = 1.0;
            double dx = bx - ax;
            double dy = by - ay;
            double r = this.x0 - ax;
            if (!ObjectConverter.toBoolean(dx) && r > 0.0) {
                return null;
            }
            r /= dx;
            if (dx < 0.0) {
                if (r < t0) {
                    return null;
                }
                if (r < t1) {
                    t1 = r;
                }
            } else if (dx > 0.0) {
                if (r > t1) {
                    return null;
                }
                if (r > t0) {
                    t0 = r;
                }
            }
            r = this.x1 - ax;
            if (!ObjectConverter.toBoolean(dx) && r < 0.0) {
                return null;
            }
            r /= dx;
            if (dx < 0.0) {
                if (r > t1) {
                    return null;
                }
                if (r > t0) {
                    t0 = r;
                }
            } else if (dx > 0.0) {
                if (r < t0) {
                    return null;
                }
                if (r < t1) {
                    t1 = r;
                }
            }
            r = this.y0 - ay;
            if (!ObjectConverter.toBoolean(dy) && r > 0.0) {
                return null;
            }
            r /= dy;
            if (dy < 0.0) {
                if (r < t0) {
                    return null;
                }
                if (r < t1) {
                    t1 = r;
                }
            } else if (dy > 0.0) {
                if (r > t1) {
                    return null;
                }
                if (r > t0) {
                    t0 = r;
                }
            }
            r = this.y1 - ay;
            if (!ObjectConverter.toBoolean(dy) && r < 0.0) {
                return null;
            }
            r /= dy;
            if (dy < 0.0) {
                if (r > t1) {
                    return null;
                }
                if (r > t0) {
                    t0 = r;
                }
            } else if (dy > 0.0) {
                if (r < t0) {
                    return null;
                }
                if (r < t1) {
                    t1 = r;
                }
            }
            if (t0 > 0.0) {
                line.setA(this.pointCreator.apply(ax + t0 * dx, ay + t0 * dy));
            }
            if (t1 < 1.0) {
                line.setB(this.pointCreator.apply(ax + t1 * dx, ay + t1 * dy));
            }
            return line;
        }
    }

    @FunctionClass(value="apply")
    @SwiftClosure(value="apply")
    public static interface PointCreator {
        public PointStruct apply(double var1, double var3);
    }

    @FunctionClass(value="clip")
    @SwiftClosure(value="clip")
    public static interface LineClipper {
        public Line clip(Line var1);
    }
}

