/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.geom;

import com.ibm.rave.codegenerator.annotations.FunctionClass;
import com.ibm.rave.codegenerator.annotations.SwiftClosure;
import com.ibm.vida.rave.core.geom.Point;
import com.ibm.vida.rave.core.geom.PointStruct;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import java.util.List;

@FunctionClass(value="quadtree")
public class QuadTree<T> {
    private ValueFunction<T> fx;
    private ValueFunction<T> fy;
    private Object xVal;
    private Object yVal;
    private double x1 = Double.NaN;
    private double y1;
    private double x2;
    private double y2;

    public static <T extends PointStruct> RootQTNode<T> createQuadTree(List<T> data, double x1, double y1, double x2, double y2) {
        QuadTree<T> qTree = new QuadTree<T>();
        qTree.fx = QuadTree.FX_COMP_FN();
        qTree.fy = QuadTree.FY_COMP_FN();
        qTree.xVal = qTree.fx;
        qTree.yVal = qTree.fy;
        qTree.x1 = x1;
        qTree.y1 = y1;
        qTree.x2 = x2;
        qTree.y2 = y2;
        return qTree.quadtree(data);
    }

    public static <T extends PointStruct> RootQTNode<T> createQuadTree(List<T> data, double x1, double y1) {
        return QuadTree.createQuadTree(data, 0.0, 0.0, x1, y1);
    }

    public static <T extends PointStruct> RootQTNode<T> createQuadTree(List<T> data) {
        QuadTree<T> qTree = new QuadTree<T>();
        qTree.fx = QuadTree.FX_COMP_FN();
        qTree.fy = QuadTree.FY_COMP_FN();
        qTree.xVal = qTree.fx;
        qTree.yVal = qTree.fy;
        return qTree.quadtree(data);
    }

    public static <T> QuadTree<T> createQuadTree() {
        QuadTree<T> qTree = new QuadTree<T>();
        qTree.fx = QuadTree.FX_FN();
        qTree.fy = QuadTree.FY_FN();
        qTree.xVal = qTree.fx;
        qTree.yVal = qTree.fy;
        return qTree;
    }

    public RootQTNode<T> quadtree(List<T> data) {
        double y2_;
        double x2_;
        double y1_;
        double x1_;
        int n = data.size();
        double[] xs = null;
        double[] ys = null;
        if (!Double.isNaN(this.x1)) {
            x1_ = this.x1;
            y1_ = this.y1;
            x2_ = this.x2;
            y2_ = this.y2;
        } else {
            y1_ = Double.POSITIVE_INFINITY;
            x1_ = Double.POSITIVE_INFINITY;
            x2_ = y2_ = -Double.POSITIVE_INFINITY;
            xs = new double[n];
            ys = new double[n];
            for (int i = 0; i < n; ++i) {
                T d = data.get(i);
                double x_ = this.fx.getValue(d, i);
                double y_ = this.fy.getValue(d, i);
                if (x_ < x1_) {
                    x1_ = x_;
                }
                if (y_ < y1_) {
                    y1_ = y_;
                }
                if (x_ > x2_) {
                    x2_ = x_;
                }
                if (y_ > y2_) {
                    y2_ = y_;
                }
                xs[i] = x_;
                ys[i] = y_;
            }
        }
        double dx = x2_ - x1_;
        double dy = y2_ - y1_;
        if (dx > dy) {
            y2_ = y1_ + dx;
        } else {
            x2_ = x1_ + dy;
        }
        RootQTNode<T> root = new RootQTNode<T>(x1_, y1_, x2_, y2_, this.fx, this.fy);
        if (Double.isNaN(this.x1)) {
            int i = -1;
            while (++i < n) {
                QuadTree.insert(root, data.get(i), xs[i], ys[i], x1_, y1_, x2_, y2_);
            }
            ((RootQTNode)root).i = --i;
        } else {
            for (int i = 0; i < n; ++i) {
                root.add(data.get(i));
            }
        }
        return root;
    }

    public Object x() {
        return this.xVal;
    }

    public QuadTree<T> x(final double x) {
        this.fx = new ValueFunction<T>(){

            @Override
            public double getValue(T data, int index) {
                return x;
            }
        };
        this.xVal = x;
        return this;
    }

    public QuadTree<T> x(ValueFunction<T> x) {
        this.fx = x;
        this.xVal = x;
        return this;
    }

    public Object y() {
        return this.yVal;
    }

    public QuadTree<T> y(final double y) {
        this.fy = new ValueFunction<T>(){

            @Override
            public double getValue(T data, int index) {
                return y;
            }
        };
        this.yVal = y;
        return this;
    }

    public QuadTree<T> y(ValueFunction<T> y) {
        this.fy = y;
        this.yVal = y;
        return this;
    }

    public Point[] extent() {
        Point[] pointArray;
        if (Double.isNaN(this.x1)) {
            pointArray = null;
        } else {
            Point[] pointArray2 = new Point[2];
            pointArray2[0] = new Point(this.x1, this.y1);
            pointArray = pointArray2;
            pointArray2[1] = new Point(this.x2, this.y2);
        }
        return pointArray;
    }

    public QuadTree<T> extent(Point[] extent) {
        if (extent == null) {
            this.y2 = Double.NaN;
            this.x2 = Double.NaN;
            this.y1 = Double.NaN;
            this.x1 = Double.NaN;
        } else {
            this.x1 = extent[0].getX();
            this.y1 = extent[0].getY();
            this.x2 = extent[1].getX();
            this.y2 = extent[1].getY();
        }
        return this;
    }

    public Point size() {
        return Double.isNaN(this.x1) ? null : new Point(this.x2 - this.x1, this.y2 - this.y1);
    }

    public QuadTree<T> size(Point size) {
        if (size == null) {
            this.y2 = Double.NaN;
            this.x2 = Double.NaN;
            this.y1 = Double.NaN;
            this.x1 = Double.NaN;
        } else {
            this.y2 = 0.0;
            this.x1 = 0.0;
            this.x2 = size.getX();
            this.y2 = size.getY();
        }
        return this;
    }

    protected static <T> void quadtreeVisit(Visitor<T> f, QTNode<T> node, double x1, double y1, double x2, double y2) {
        QTNode<T>[] children = node.nodes;
        if (!f.visit(node, x1, y1, x2, y2) && children != null) {
            double sx = (x1 + x2) * 0.5;
            double sy = (y1 + y2) * 0.5;
            if (children[0] != null) {
                QuadTree.quadtreeVisit(f, children[0], x1, y1, sx, sy);
            }
            if (children[1] != null) {
                QuadTree.quadtreeVisit(f, children[1], sx, y1, x2, sy);
            }
            if (children[2] != null) {
                QuadTree.quadtreeVisit(f, children[2], x1, sy, sx, y2);
            }
            if (children[3] != null) {
                QuadTree.quadtreeVisit(f, children[3], sx, sy, x2, y2);
            }
        }
    }

    protected static <T> void insert(QTNode<T> n, T d, double x, double y, double x1, double y1, double x2, double y2) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return;
        }
        if (n.leaf) {
            double nx = n.x;
            double ny = n.y;
            if (!Double.isNaN(nx)) {
                if (Math.abs(nx - x) + Math.abs(ny - y) < 0.01) {
                    QuadTree.insertChild(n, d, x, y, x1, y1, x2, y2);
                } else {
                    Object nPoint = n.point;
                    n.point = null;
                    n.y = Double.NaN;
                    n.x = Double.NaN;
                    QuadTree.insertChild(n, nPoint, nx, ny, x1, y1, x2, y2);
                    QuadTree.insertChild(n, d, x, y, x1, y1, x2, y2);
                }
            } else {
                n.x = x;
                n.y = y;
                n.point = d;
            }
        } else {
            QuadTree.insertChild(n, d, x, y, x1, y1, x2, y2);
        }
    }

    private static <T> void insertChild(QTNode<T> n, T d, double x, double y, double x1, double y1, double x2, double y2) {
        boolean below;
        QTNode<T> _n = n;
        double _x1 = x1;
        double _y1 = y1;
        double _x2 = x2;
        double _y2 = y2;
        double xm = (_x1 + _x2) * 0.5;
        double ym = (_y1 + _y2) * 0.5;
        boolean right = x >= xm;
        boolean bl = below = y >= ym;
        int i = below ? (right ? 3 : 2) : (right ? 1 : 0);
        _n.leaf = false;
        if (_n.nodes[i] == null) {
            _n.nodes[i] = new QTNode();
        }
        _n = _n.nodes[i];
        if (right) {
            _x1 = xm;
        } else {
            _x2 = xm;
        }
        if (below) {
            _y1 = ym;
        } else {
            _y2 = ym;
        }
        QuadTree.insert(_n, d, x, y, _x1, _y1, _x2, _y2);
    }

    private static <T extends PointStruct> ValueFunction<T> FX_COMP_FN() {
        return new ValueFunction<T>(){

            @Override
            public double getValue(PointStruct data, int index) {
                return data.x;
            }
        };
    }

    private static <T extends PointStruct> ValueFunction<T> FY_COMP_FN() {
        return new ValueFunction<T>(){

            @Override
            public double getValue(PointStruct data, int index) {
                return data.y;
            }
        };
    }

    private static <T> ValueFunction<T> FX_FN() {
        return new ValueFunction<T>(){

            @Override
            public double getValue(T data, int index) {
                return ((Point)data).getX();
            }
        };
    }

    private static <T> ValueFunction<T> FY_FN() {
        return new ValueFunction<T>(){

            @Override
            public double getValue(T data, int index) {
                return ((Point)data).getY();
            }
        };
    }

    private static class Finder<T> {
        private final double x;
        private final double y;
        private double x0;
        private double y0;
        private double x3;
        private double y3;
        private double minDistance2 = Double.POSITIVE_INFINITY;
        T closestPoint;

        Finder(double x, double y, double x0, double y0, double x3, double y3) {
            this.x = x;
            this.y = y;
            this.x0 = x0;
            this.y0 = y0;
            this.x3 = x3;
            this.y3 = y3;
        }

        Finder<T> find(QTNode<T> node, double x1, double y1, double x2, double y2) {
            int i;
            double dy;
            double dx;
            double distance2;
            QTNode<T> _node = node;
            if (x1 > this.x3 || y1 > this.y3 || x2 < this.x0 || y2 < this.y0) {
                return this;
            }
            Object point = _node.point;
            if (point != null && (distance2 = (dx = this.x - _node.x) * dx + (dy = this.y - _node.y) * dy) < this.minDistance2) {
                this.minDistance2 = distance2;
                double distance = Math.sqrt(this.minDistance2);
                this.x0 = this.x - distance;
                this.y0 = this.y - distance;
                this.x3 = this.x + distance;
                this.y3 = this.y + distance;
                this.closestPoint = point;
            }
            QTNode<T>[] children = _node.nodes;
            double xm = (x1 + x2) * 0.5;
            double ym = (y1 + y2) * 0.5;
            int right = ObjectConverter.toNumber(this.x >= xm);
            int below = ObjectConverter.toNumber(this.y >= ym);
            int j = i + 4;
            block6: for (i = below << 1 | right; i < j; ++i) {
                _node = children[i & 3];
                if (_node == null) continue;
                switch (i & 3) {
                    case 0: {
                        this.find(_node, x1, y1, xm, ym);
                        continue block6;
                    }
                    case 1: {
                        this.find(_node, xm, y1, x2, ym);
                        continue block6;
                    }
                    case 2: {
                        this.find(_node, x1, ym, xm, y2);
                        continue block6;
                    }
                    case 3: {
                        this.find(_node, xm, ym, x2, y2);
                    }
                }
            }
            return this;
        }
    }

    @FunctionClass(value="getValue")
    @SwiftClosure(value="getValue")
    public static interface ValueFunction<T> {
        public double getValue(T var1, int var2);
    }

    @FunctionClass(value="visit")
    @SwiftClosure(value="visit")
    public static interface Visitor<T> {
        public boolean visit(QTNode<T> var1, double var2, double var4, double var6, double var8);
    }

    public static class RootQTNode<T>
    extends QTNode<T> {
        private final ValueFunction<T> fx;
        private final ValueFunction<T> fy;
        private final double _x1;
        private final double _y1;
        private final double _x2;
        private final double _y2;
        private int i = -1;

        private RootQTNode(double x1, double y1, double x2, double y2, ValueFunction<T> fx, ValueFunction<T> fy) {
            this._x1 = x1;
            this._y1 = y1;
            this._x2 = x2;
            this._y2 = y2;
            this.fx = fx;
            this.fy = fy;
        }

        public void visit(Visitor<T> visitor) {
            QuadTree.quadtreeVisit(visitor, this, this._x1, this._y1, this._x2, this._y2);
        }

        public T find(Point point1) {
            return new Finder<T>((double)point1.getX(), (double)point1.getY(), (double)this._x1, (double)this._y1, (double)this._x2, (double)this._y2).find(this, (double)this._x1, (double)this._y1, (double)this._x2, (double)this._y2).closestPoint;
        }

        public void add(T d) {
            QuadTree.insert(this, d, this.fx.getValue(d, ++this.i), this.fy.getValue(d, this.i), this._x1, this._y1, this._x2, this._y2);
        }
    }

    public static class QTNode<T> {
        public boolean leaf = true;
        public QTNode<T>[] nodes = new QTNode[4];
        public T point;
        public double x = Double.NaN;
        public double y = Double.NaN;
        public Object data;
    }
}

