/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.globalization;

import com.ibm.rave.codegenerator.annotations.SwiftMethodOverload;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.globalization.AbstractNumericShaper;
import com.ibm.vida.rave.core.internal.globalization.BidiStringDirection;
import com.ibm.vida.rave.core.internal.globalization.NumericShaperFactory;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.globalization.BidiProcess;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.ValueFunction;
import java.util.List;

public class BidiStringFormatter
implements ValueFunction<Object, String> {
    private int dir = 4;
    private String numericShapingValue = "";
    private String defaultNumericContext = "";
    private ArrayEx<String> digitMappingList = new ArrayEx();

    public final BidiStringFormatter direction(String direction) {
        this.dir = BidiStringDirection.parse(direction);
        return this;
    }

    public final String direction() {
        return BidiStringDirection.toString(this.dir);
    }

    public BidiStringFormatter numericShaping(String numericShapingType) {
        this.numericShapingValue = numericShapingType != null ? numericShapingType.toLowerCase() : null;
        return this;
    }

    public String numericShaping() {
        return this.numericShapingValue;
    }

    public BidiStringFormatter defaultContext(String defaultContext) {
        this.defaultNumericContext = defaultContext;
        return this;
    }

    public String defaultContext() {
        return this.defaultNumericContext;
    }

    public BidiStringFormatter digitMapping(List<String> digitTypes) {
        String[] array = digitTypes.toArray(new String[0]);
        this.digitMappingList = Lang.toArray(array);
        return this;
    }

    public BidiStringFormatter digitMapping(String string) {
        this.digitMappingList = new ArrayEx<String>(string);
        return this;
    }

    public ArrayEx<String> digitMapping() {
        if (this.digitMappingList.size() == 0 && this.defaultNumericContext != null) {
            return new ArrayEx<String>(this.defaultNumericContext);
        }
        return this.digitMappingList;
    }

    @Override
    @SwiftMethodOverload(overloads={"String"})
    public String getValue(Object context, Object string, int index, int groupIndex) {
        int textDirection;
        String bidiString = ObjectConverter.toString(string);
        if (this.numericShapingValue != null) {
            AbstractNumericShaper shaper = NumericShaperFactory.create(this);
            bidiString = shaper.shape(bidiString);
        }
        if ((textDirection = this.dir) == 3) {
            textDirection = BidiProcess.determineDirection(bidiString);
        }
        if (textDirection == 0) {
            bidiString = '\u202a' + bidiString + '\u202c';
        } else if (textDirection == 1) {
            bidiString = '\u202b' + bidiString + '\u202c';
        }
        return bidiString;
    }
}

