/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.css.CSSStyleDeclaration;
import com.ibm.vida.rave.core.css.CSSStyleSheet;
import com.ibm.vida.rave.core.internal.collections.OSet;
import com.ibm.vida.rave.core.internal.css.CSSValueParser;
import com.ibm.vida.rave.core.internal.css.om.CSSStyleDeclarationImpl;
import com.ibm.vida.rave.core.internal.css.om.CSSStyleRuleImpl;
import com.ibm.vida.rave.core.internal.css.om.CSSStyleSheetImpl;
import com.ibm.vida.rave.core.internal.css.om.CSSValue;
import com.ibm.vida.rave.core.internal.css.om.CSSValueList;
import com.ibm.vida.rave.core.internal.css.rules.CSSKeyframeRule;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import java.util.ArrayList;
import java.util.List;

public class CSSParser {
    private static final int BEFORE_NAME = 1000;
    private static final int BEFORE_SELECTOR = 1001;
    private static final int BEFORE_VALUE = 1002;
    private static final int SELECTOR = 1003;
    private static final int KEYFRAMERULE_BEGIN = 1004;
    private static final int NAME = 1005;
    private static final int VALUE = 1006;
    private static final int IMPORTRULE_BEGIN = 1007;
    private static final int IMPORTRULE = 1008;
    private static final int DOCUMENTRULE_BEGIN = 1009;
    private static final int ATBLOCK = 1010;
    private static final int FONTFACERULE_BEGIN = 1011;
    private static final int KEYFRAMESRULE_BEGIN = 1012;
    private static final int ATRULE = 1013;
    private static final int CHARSETRULE_BEGIN = 1014;
    private static final int CHARSETRULE = 1015;
    @InlineStringConstant
    private static final String AT_KEYFRAMES_REG_EXP_KEY = "AT_KEYFRAMES_REG_EXP_KEY";
    private static OSet<Integer> SIGNIFICANT_WHITESPACE = CSSParser.generateWhitespaceMap();
    private static final int INSIDE_SELECTOR_PIECE = 1000;
    private static final int OUTSIDE_SELECTOR_PIECE = 1001;
    private static final int INSIDE_BRACKETS = 1002;
    private static final int INSIDE_OR = 1003;

    private static RegExp getAtKeyframesRegExp() {
        RegExp atKeyframesRegExp = (RegExp)RaveContextManager.INSTANCE.getRaveContext().getData(AT_KEYFRAMES_REG_EXP_KEY);
        if (atKeyframesRegExp == null) {
            atKeyframesRegExp = new RegExp("@(-(?:\\w+-)+)?keyframes", "g");
            RaveContextManager.INSTANCE.getRaveContext().putData(AT_KEYFRAMES_REG_EXP_KEY, atKeyframesRegExp);
        }
        return atKeyframesRegExp;
    }

    public static CSSStyleDeclaration parseStyle(String styleName, String token) {
        CSSStyleSheet sheet = CSSParser.parse("*{" + styleName + ":" + token + "}");
        if (sheet != null && sheet.getCssRules() != null && sheet.getCssRules().size() > 0) {
            return sheet.getCssRules().get(0).getStyle();
        }
        return null;
    }

    private static OSet<Integer> generateWhitespaceMap() {
        OSet<Integer> whitespaceMap = new OSet<Integer>();
        whitespaceMap.add(1003);
        whitespaceMap.add(1006);
        whitespaceMap.add(1013);
        whitespaceMap.add(1007);
        whitespaceMap.add(1008);
        whitespaceMap.add(1010);
        whitespaceMap.add(1009);
        return whitespaceMap;
    }

    public static CSSStyleSheet parse(String cssText) {
        CSSStyleSheetImpl styleSheet = new CSSStyleSheetImpl();
        if (cssText == null || cssText.length() == 0) {
            return styleSheet;
        }
        int state = 1001;
        String buffer = "";
        CSSStyleSheetImpl currentScope = styleSheet;
        Object parentRule = null;
        String name = null;
        String priority = "";
        CSSStyleRuleImpl styleRule = new CSSStyleRuleImpl();
        CSSValue cssValue = null;
        String currentOperation = "";
        boolean inWhitespace = true;
        boolean specificityChange = false;
        for (int i = 0; i < cssText.length(); ++i) {
            char character = cssText.charAt(i);
            if (CSSParser.isWhitespace(character)) {
                if (!inWhitespace && SIGNIFICANT_WHITESPACE.contains(state)) {
                    buffer = buffer + " ";
                }
                inWhitespace = true;
                specificityChange = true;
                continue;
            }
            int currentSpecificity = 1;
            if (state == 1001 || state == 1003) {
                switch (character) {
                    case '.': 
                    case '[': {
                        currentSpecificity = 16;
                        specificityChange = true;
                        break;
                    }
                    case '#': {
                        currentSpecificity = 256;
                        specificityChange = true;
                    }
                }
            }
            block4 : switch (character) {
                case '\"': {
                    int index = i + 1;
                    do {
                        if ((index = cssText.indexOf("\"", index) + 1) != 0) continue;
                        return null;
                    } while (cssText.charAt(index - 2) == '\\');
                    buffer = buffer + cssText.substring(i, index);
                    i = index - 1;
                    if (state == 1002) {
                        state = 1006;
                        break;
                    }
                    if (state == 1007) {
                        state = 1008;
                        break;
                    }
                    if (state != 1014) break;
                    state = 1015;
                    break;
                }
                case '\'': {
                    int index = i + 1;
                    do {
                        if ((index = cssText.indexOf("'", index) + 1) != 0) continue;
                        return null;
                    } while (cssText.charAt(index - 2) == '\\');
                    buffer = buffer + cssText.substring(i, index);
                    i = index - 1;
                    switch (state) {
                        case 1002: {
                            state = 1006;
                            break block4;
                        }
                        case 1007: {
                            state = 1008;
                            break block4;
                        }
                        case 1014: {
                            state = 1015;
                            break block4;
                        }
                    }
                    break;
                }
                case '/': {
                    int index;
                    if (cssText.charAt(i + 1) == '*') {
                        index = cssText.indexOf("*/", i += 2);
                        if (index == -1) {
                            return null;
                        }
                        i = index + 1;
                    } else {
                        buffer = buffer + character;
                    }
                    if (state == 1007) {
                        buffer = buffer + " ";
                        state = 1008;
                        break;
                    }
                    if (state != 1014) break;
                    buffer = buffer + " ";
                    state = 1015;
                    break;
                }
                case '@': {
                    if (cssText.indexOf("@-moz-document", i) == i) {
                        state = 1009;
                        i += "-moz-document".length();
                        buffer = "";
                        break;
                    }
                    if (cssText.indexOf("@media", i) == i) {
                        state = 1010;
                        i += 5;
                        buffer = "";
                        break;
                    }
                    if (cssText.indexOf("@import", i) == i) {
                        state = 1007;
                        i += 6;
                        buffer = buffer + "@import";
                        break;
                    }
                    if (cssText.indexOf("@charset", i) == i) {
                        state = 1014;
                        i += 7;
                        buffer = buffer + "@import";
                        break;
                    }
                    if (cssText.indexOf("@font-face", i) == i) {
                        state = 1011;
                        i += 9;
                        buffer = "";
                        break;
                    }
                    RegExp atKeyframesRegExp = CSSParser.getAtKeyframesRegExp();
                    atKeyframesRegExp.lastIndex = i;
                    RegExp.RegExpResult matchKeyframes = atKeyframesRegExp.exec(cssText);
                    if (matchKeyframes != null && matchKeyframes.index == i) {
                        state = 1012;
                        i += ((String)matchKeyframes.get(0)).length() - 1;
                        buffer = "";
                        break;
                    }
                    if (state == 1003) {
                        state = 1013;
                    }
                    buffer = buffer + character;
                    break;
                }
                case '{': {
                    if (state == 1003 || state == 1013) {
                        styleRule.setSelectorText(buffer.trim());
                        styleRule.setStyle(styleRule.getStyle() == null ? new CSSStyleDeclarationImpl() : styleRule.getStyle());
                        buffer = "";
                        state = 1000;
                        break;
                    }
                    if (state == 1010) {
                        buffer = "";
                        state = 1001;
                        break;
                    }
                    if (state == 1011) {
                        buffer = "";
                        state = 1000;
                        break;
                    }
                    if (state == 1012) {
                        buffer = "";
                        state = 1004;
                        break;
                    }
                    if (state == 1004) {
                        styleRule = new CSSKeyframeRule();
                        ((CSSKeyframeRule)styleRule).keyText = buffer.trim();
                        buffer = "";
                        state = 1000;
                        break;
                    }
                    if (state != 1009) break;
                    buffer = "";
                    state = 1001;
                    break;
                }
                case ':': {
                    if (state == 1005) {
                        name = buffer.trim();
                        buffer = "";
                        state = 1002;
                        break;
                    }
                    if (state == 1003) {
                        specificityChange = true;
                        styleRule._specificity += 16;
                        buffer = buffer + character;
                        break;
                    }
                    buffer = buffer + character;
                    break;
                }
                case '(': {
                    if (state == 1006) {
                        int propertyType = CSSParser.determinePropertyType(name);
                        if (cssValue == null) {
                            cssValue = CSSParser.createValueContainer(propertyType);
                        }
                        CSSValueParser.CSSValueExpressionInfo info = CSSParser.parseValues(propertyType, currentOperation, cssText, i);
                        i = info.idx;
                        if (info.error == 0) {
                            buffer = buffer + info.expression;
                            if (cssValue != null && cssValue.getType() == 2) {
                                ((CSSValueList)cssValue).append(info.cssValue);
                            } else {
                                cssValue = info.cssValue;
                            }
                        } else {
                            buffer = "";
                        }
                        currentOperation = "";
                        break;
                    }
                    buffer = buffer + character;
                    break;
                }
                case '!': {
                    if (state == 1006 && cssText.indexOf("!important", i) == i) {
                        priority = "important";
                        i += "important".length();
                        break;
                    }
                    buffer = buffer + character;
                    break;
                }
                case ';': {
                    switch (state) {
                        case 1006: {
                            styleRule.setStyle(styleRule.getStyle() == null ? new CSSStyleDeclarationImpl() : styleRule.getStyle());
                            styleRule.getStyle().setProperty(name, buffer.trim(), priority);
                            ((CSSStyleDeclarationImpl)styleRule.getStyle()).setPropertyCSSValue(name, cssValue);
                            priority = "";
                            buffer = "";
                            state = 1000;
                            cssValue = null;
                            break block4;
                        }
                        case 1013: {
                            buffer = "";
                            state = 1001;
                            break block4;
                        }
                        case 1008: 
                        case 1015: {
                            buffer = "";
                            state = 1001;
                            break block4;
                        }
                    }
                    buffer = buffer + character;
                    break;
                }
                case '}': {
                    switch (state) {
                        case 1006: {
                            styleRule.setStyle(styleRule.getStyle() == null ? new CSSStyleDeclarationImpl() : styleRule.getStyle());
                            styleRule.getStyle().setProperty(name, buffer.trim(), priority);
                            ((CSSStyleDeclarationImpl)styleRule.getStyle()).setPropertyCSSValue(name, cssValue);
                            priority = "";
                            cssValue = null;
                        }
                        case 1000: 
                        case 1005: {
                            if (parentRule != null) {
                                styleRule.setParentRule(parentRule);
                            }
                            styleRule.setParentStyleSheet(styleSheet);
                            currentScope.getCssRules().add(styleRule);
                            buffer = "";
                            if (((CSSStyleSheet)currentScope).getType() == 7) {
                                state = 1004;
                                break;
                            }
                            state = 1001;
                            break;
                        }
                        case 1001: 
                        case 1003: 
                        case 1004: {
                            if (parentRule != null) {
                                // empty if block
                            }
                            currentScope = styleSheet;
                            parentRule = null;
                            buffer = "";
                            state = 1001;
                        }
                    }
                    break;
                }
                default: {
                    switch (state) {
                        case 1001: {
                            state = 1003;
                            styleRule = new CSSStyleRuleImpl();
                            styleRule._specificity = currentSpecificity;
                            break;
                        }
                        case 1003: {
                            if (!specificityChange) break;
                            styleRule._specificity += currentSpecificity;
                            break;
                        }
                        case 1000: {
                            state = 1005;
                            break;
                        }
                        case 1002: {
                            state = 1006;
                        }
                        case 1006: {
                            currentOperation = currentOperation + character;
                            break;
                        }
                        case 1014: {
                            state = 1015;
                            break;
                        }
                        case 1007: {
                            state = 1008;
                        }
                    }
                    buffer = buffer + character;
                }
            }
            inWhitespace = false;
            specificityChange = false;
        }
        return styleSheet;
    }

    private static boolean isWhitespace(char character) {
        switch (character) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    private static CSSValue createValueContainer(int propertyType) {
        CSSValueList cssValue = null;
        if (propertyType == 0) {
            cssValue = new CSSValueList();
        }
        return cssValue;
    }

    private static CSSValueParser.CSSValueExpressionInfo parseValues(int propertyType, String buffer, String token, int i) {
        CSSValueParser valueExpression = new CSSValueParser(propertyType, buffer, token, i);
        return valueExpression.parse();
    }

    private static int determinePropertyType(String type) {
        if (type.equals("transform")) {
            return 0;
        }
        return -1;
    }

    public static List<String> deconstructSelectorText(String selectorText) {
        String _selectorText = selectorText;
        int state = 1000;
        ArrayList<String> results = new ArrayList<String>();
        _selectorText = _selectorText.trim();
        String currentBuffer = "";
        block5: for (int i = 0; i < _selectorText.length(); ++i) {
            char character = _selectorText.charAt(i);
            if (CSSParser.isWhitespace(character)) {
                if (state == 1000) {
                    state = 1001;
                    continue;
                }
                if (state != 1002) continue;
                currentBuffer = currentBuffer + character;
                continue;
            }
            switch (character) {
                case '(': 
                case '[': {
                    if (state == 1001) {
                        state = 1000;
                        results.add(currentBuffer);
                        currentBuffer = "";
                    }
                    state = 1002;
                    currentBuffer = currentBuffer + character;
                    continue block5;
                }
                case ')': 
                case ']': {
                    if (state != 1002) {
                        state = 1001;
                    }
                    currentBuffer = currentBuffer + character;
                    continue block5;
                }
                case '+': 
                case '>': 
                case '~': {
                    if (state == 1000) {
                        state = 1001;
                        continue block5;
                    }
                    if (state != 1002) continue block5;
                    currentBuffer = currentBuffer + character;
                    continue block5;
                }
                default: {
                    if (state == 1001) {
                        state = 1000;
                        results.add(currentBuffer);
                        currentBuffer = "";
                    }
                    currentBuffer = currentBuffer + character;
                }
            }
        }
        results.add(currentBuffer);
        return results;
    }

    public static List<String> splitSelectorText(String selectorText) {
        int innerState = 0;
        ArrayList<String> results = new ArrayList<String>();
        String currentBuffer = "";
        block5: for (int i = 0; i < selectorText.length(); ++i) {
            char character = selectorText.charAt(i);
            switch (character) {
                case '(': 
                case '[': {
                    ++innerState;
                    currentBuffer = currentBuffer + character;
                    continue block5;
                }
                case ')': 
                case ']': {
                    --innerState;
                    currentBuffer = currentBuffer + character;
                    continue block5;
                }
                case ',': {
                    if (innerState != 0) continue block5;
                    results.add(currentBuffer.trim());
                    currentBuffer = "";
                    continue block5;
                }
                default: {
                    currentBuffer = currentBuffer + character;
                }
            }
        }
        results.add(currentBuffer.trim());
        return results;
    }
}

