/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css;

import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.internal.css.CSSParser;
import com.ibm.vida.rave.core.internal.css.CSSUtil;
import com.ibm.vida.rave.core.internal.css.om.CSSPrimitiveValue;
import com.ibm.vida.rave.core.internal.css.om.CSSStyleDeclarationImpl;
import com.ibm.vida.rave.core.internal.css.om.CSSTransformValue;
import com.ibm.vida.rave.core.internal.css.om.CSSValue;
import com.ibm.vida.rave.core.internal.css.om.CSSValueList;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.transform.Matrix;
import com.ibm.vida.rave.core.transform.MatrixUtil;
import java.util.ArrayList;
import java.util.List;

public class CSSTransformParser {
    public static Matrix parse(String style) {
        final Matrix[] matrix = new Matrix[1];
        CSSStyleDeclarationImpl declaration = (CSSStyleDeclarationImpl)CSSParser.parseStyle("transform", style);
        if (declaration != null) {
            declaration.each(new CSSValue.CSSValueHandler(){

                @Override
                public void handle(String name, CSSValue value, int i) {
                    CSSValueList valueList = (CSSValueList)value;
                    if (valueList != null) {
                        valueList.each(new CSSValue.CSSValueHandler(){

                            @Override
                            public void handle(String _name, CSSValue _value, int index) {
                                CSSTransformValue transformValue = (CSSTransformValue)_value;
                                Matrix newMatrix = CSSTransformParser.create(_name, transformValue);
                                if (matrix[0] != null) {
                                    newMatrix = matrix[0].multiply(newMatrix);
                                }
                                matrix[0] = newMatrix;
                            }
                        });
                    }
                }
            });
        }
        return matrix[0];
    }

    static Matrix create(String operator, CSSTransformValue transformValue) {
        Matrix result = MatrixUtil.identity();
        final ArrayList<CSSPrimitiveValue> values = new ArrayList<CSSPrimitiveValue>();
        transformValue.each(new CSSValue.CSSValueHandler(){

            @Override
            public void handle(String name, CSSValue value, int index) {
                values.add((CSSPrimitiveValue)value);
            }
        });
        if (values.size() > 0) {
            double firstValue = CSSTransformParser.convert(values, 0);
            int type = CSSTransformValue.determineType(operator);
            switch (type) {
                case 5: {
                    if (values.size() == 1) {
                        result = result.scale(firstValue);
                        break;
                    }
                    if (values.size() != 2) break;
                    result = result.scaleNonUniform(firstValue, CSSTransformParser.convert(values, 1));
                    break;
                }
                case 6: {
                    result = result.scaleNonUniform(firstValue, 1.0);
                    break;
                }
                case 7: {
                    result = result.scaleNonUniform(1.0, firstValue);
                    break;
                }
                case 4: {
                    if (values.size() > 2) {
                        result = result.rotate(firstValue, CSSTransformParser.convert(values, 1), CSSTransformParser.convert(values, 2));
                        break;
                    }
                    if (values.size() != 1) break;
                    result = result.rotate(firstValue);
                    break;
                }
                case 8: {
                    if (values.size() <= 1) break;
                    result = result.skewX(firstValue).skewY(CSSTransformParser.convert(values, 1));
                    break;
                }
                case 9: {
                    result = result.skewX(firstValue);
                    break;
                }
                case 10: {
                    result = result.skewY(firstValue);
                    break;
                }
                case 1: {
                    if (values.size() > 1) {
                        result = result.translate(firstValue, CSSTransformParser.convert(values, 1));
                        break;
                    }
                }
                case 2: {
                    result = result.translate(firstValue, 0.0);
                    break;
                }
                case 3: {
                    result = result.translate(0.0, firstValue);
                    break;
                }
                case 11: {
                    if (values.size() != 6) break;
                    result = MatrixUtil.create(firstValue, CSSTransformParser.convert(values, 1), CSSTransformParser.convert(values, 2), CSSTransformParser.convert(values, 3), CSSTransformParser.convert(values, 4), CSSTransformParser.convert(values, 5));
                    break;
                }
            }
        }
        return result;
    }

    private static double convert(List<CSSPrimitiveValue> values, int index) {
        CSSSize size = CSSUtil.parseSize(values.get((int)index).value);
        return ObjectConverter.toDouble(size.value);
    }
}

