/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css;

import com.ibm.rave.codegenerator.annotations.InlineStringConstant;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.context.RaveContextManager;
import com.ibm.vida.rave.core.css.CSSSize;
import com.ibm.vida.rave.core.css.CSSUnit;
import com.ibm.vida.rave.core.internal.nativeImpl.Lang;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;

public final class CSSUtil {
    @InlineStringConstant
    private static final String LINK_REGEX_KEY = "LINK_REGEX_KEY";

    private static RegExp getLinkRegExp() {
        RegExp linkRegex = (RegExp)RaveContextManager.INSTANCE.getRaveContext().getData(LINK_REGEX_KEY);
        if (linkRegex == null) {
            linkRegex = new RegExp("url\\s*?\\(['\"]?#([^\\)'\"]+)['\"]?\\)", "i");
            RaveContextManager.INSTANCE.getRaveContext().putData(LINK_REGEX_KEY, linkRegex);
        }
        return linkRegex;
    }

    public static final float[] parseDashArray(String value) {
        float[] dashArray = null;
        if (value != null && !"none".equals(value.toLowerCase()) && value.length() > 0) {
            String[] parts = value.split(",");
            boolean odd = parts.length % 2 == 1;
            dashArray = new float[parts.length * (odd ? 2 : 1)];
            int i = 0;
            for (String part : parts) {
                CSSSize parsed = CSSUtil.parseSize(part = part.trim());
                if (parsed == null) {
                    return null;
                }
                dashArray[i++] = (float)parsed.value;
            }
            if (odd) {
                for (int j = 0; j < parts.length; ++j) {
                    dashArray[i++] = dashArray[j];
                }
            }
        }
        return dashArray;
    }

    public static final CSSSize parseSize(Object value) {
        double size;
        if (value == null) {
            return null;
        }
        CSSUnit unit = null;
        if (Lang.isNumber(value)) {
            size = ObjectConverter.toDouble(value);
        } else {
            String str = value.toString();
            int length = str.length();
            if (length > 1) {
                int unitLength = 2;
                if (length > 2) {
                    String unitStr = str.substring(length - 2).toLowerCase();
                    if (CSSUnit.UNIT_PX.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_PX;
                    } else if (CSSUnit.UNIT_PT.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_PT;
                    } else if (CSSUnit.UNIT_EM.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_EM;
                    } else if (CSSUnit.UNIT_CM.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_CM;
                    } else if (CSSUnit.UNIT_IN.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_IN;
                    } else if (CSSUnit.UNIT_MM.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_MM;
                    } else if (CSSUnit.UNIT_PC.name.equals(unitStr)) {
                        unit = CSSUnit.UNIT_PC;
                    }
                }
                if (unit == null) {
                    if (CSSUnit.UNIT_PERCENT.name.equals(str.substring(length - 1).toLowerCase())) {
                        unitLength = 1;
                        unit = CSSUnit.UNIT_PERCENT;
                    } else {
                        char c;
                        unitLength = 0;
                        for (int i = length - 1; i >= 0 && (c = str.charAt(i)) < '0' && c > '9'; --i) {
                            ++unitLength;
                        }
                    }
                }
                size = ObjectConverter.toDouble(str.substring(0, length - unitLength));
            } else {
                size = ObjectConverter.toDouble(value);
            }
        }
        return Double.isNaN(size) ? null : new CSSSize(size, unit != null ? unit : CSSUnit.UNIT_PX);
    }

    public static String parseWeight(Object weight) {
        String sWeight;
        if (weight == null) {
            return "normal";
        }
        if (Lang.isString(weight) && ("normal".equals(sWeight = ((String)weight).toLowerCase()) || "bold".equals(sWeight) || "bolder".equals(sWeight) || "lighter".equals(sWeight))) {
            return sWeight;
        }
        double value = ObjectConverter.toDouble(weight);
        if (value < 1000.0 && value > 0.0 && value % 100.0 == 0.0) {
            return ObjectConverter.toString(weight);
        }
        return null;
    }

    public static final String parseIdUrlLink(Object value) {
        if (Lang.isString(value)) {
            RegExp.RegExpResult result = CSSUtil.getLinkRegExp().exec(ObjectConverter.toString(value));
            return result != null && result.size() == 2 ? (String)result.get(1) : null;
        }
        return null;
    }

    public static final String[] parseFont(Object value) {
        String[] result = new String[]{"normal", "normal", "normal", null, null, null};
        if (value == null) {
            return result;
        }
        String str = ObjectConverter.toString(value);
        String[] splits = str.split("\\s+");
        int len = splits.length;
        for (int i = 0; i < len; ++i) {
            String val = splits[i];
            if (val.length() <= 0 || "normal".equals(val)) continue;
            if ("oblique".equals(val) || "italic".equals(val)) {
                result[0] = val;
                continue;
            }
            if ("small-caps".equals(val)) {
                result[1] = val;
                continue;
            }
            if ("bold".equals(val) || "bolder".equals(val) || "lighter".equals(val) || ObjectConverter.toDouble(val) > 0.0) {
                result[2] = val;
                continue;
            }
            if (result[3] == null) {
                String size = val;
                String lineheight = null;
                int slash = size.indexOf("/");
                if (slash > 0) {
                    lineheight = size.substring(slash + 1, size.length());
                    size = size.substring(0, slash);
                }
                if (CSSUtil.parseSize(size) != null) {
                    result[3] = size;
                    result[4] = lineheight;
                    continue;
                }
            }
            String family = splits[i];
            for (int j = i + 1; j < len; ++j) {
                if (splits[j].length() <= 0) continue;
                family = family + " " + splits[j];
            }
            result[5] = family;
            break;
        }
        return result;
    }

    public static final String parseFontFamily(Object value) {
        if (value == null) {
            return null;
        }
        String str = ObjectConverter.toString(value);
        String[] splits = str.split(",");
        boolean first = true;
        String result = "";
        for (String s : splits) {
            if ((s = s.trim().replaceAll("\"", "").replaceAll("'", "")).length() <= 0) continue;
            if (first) {
                first = false;
            } else {
                result = result + ",";
            }
            result = result + "\"" + s + "\"";
        }
        return result.length() == 0 ? null : result;
    }

    public static Object[] parseShadowStyle(Object value) {
        if (value == null) {
            return null;
        }
        String _value = ObjectConverter.toString(value);
        String[] parsed = CSSUtil._parse(_value);
        if (parsed.length == 1) {
            return null;
        }
        CSSSize offset_x = CSSUtil.parseSize(parsed[0]);
        if (offset_x == null) {
            return null;
        }
        CSSSize offset_y = CSSUtil.parseSize(parsed[1]);
        if (offset_y == null) {
            return null;
        }
        CSSSize blur_radius = parsed[2] == null ? null : CSSUtil.parseSize(parsed[2]);
        RGB _color = parsed[3] == null ? null : Rave.rgb(parsed[3]);
        return new Object[]{offset_x, offset_y, blur_radius, _color};
    }

    private static final String[] _parse(String value) {
        String str = ObjectConverter.toString(value).trim();
        String[] splits = str.split("\\s+");
        int len = splits.length;
        if (len == 1) {
            return new String[]{splits[0]};
        }
        String[] result = new String[]{null, null, null, null};
        if (len == 2) {
            result[0] = splits[0];
            result[1] = splits[1];
            return result;
        }
        if (len == 4) {
            if (CSSUtil.parseSize(splits[0]) != null || CSSUtil.parseSize(splits[3]) == null) {
                result[0] = splits[0];
                result[1] = splits[1];
                result[2] = splits[2];
                result[3] = splits[3];
            } else {
                result[0] = splits[1];
                result[1] = splits[2];
                result[2] = splits[3];
                result[3] = splits[0];
            }
            return result;
        }
        if (len == 3) {
            if (CSSUtil.parseSize(splits[0]) != null || CSSUtil.parseSize(splits[2]) == null) {
                result[0] = splits[0];
                result[1] = splits[1];
                if (CSSUtil.parseSize(splits[2]) != null) {
                    result[2] = splits[2];
                } else {
                    result[3] = splits[2];
                }
            } else {
                result[0] = splits[1];
                result[1] = splits[2];
                result[3] = splits[0];
            }
            return result;
        }
        return result;
    }
}

