/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.rave.core.internal.css;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.internal.css.om.CSSPrimitiveValue;
import com.ibm.vida.rave.core.internal.css.om.CSSTransformValue;
import com.ibm.vida.rave.core.internal.css.om.CSSValue;
import com.ibm.vida.rave.core.internal.css.om.CSSValueList;
import com.ibm.vida.rave.core.internal.nativeImpl.RegExp;

public final class CSSValueParser {
    private int type;
    private String _token;
    private int _idx;
    private String name;
    private static final int UNDEF = 0;
    private static final int INSIDE_FUNCTION = 1;
    private final CSSValueList valueList;

    public CSSValueParser(int type, String name, String token, int index) {
        this.type = type;
        this._token = token;
        this._idx = index;
        this.name = name;
        this.valueList = this.createArgumentContainer();
    }

    public CSSValueExpressionInfo parse() {
        String token = this._token;
        int idx = this._idx;
        String expression = "";
        int error = 0;
        ArrayEx<Character> paren = new ArrayEx<Character>();
        int state = 0;
        String currentArg = "";
        while (true) {
            if (idx == token.length()) {
                error = -1;
                break;
            }
            char character = token.charAt(idx);
            switch (character) {
                case '(': {
                    state = 1;
                    paren.push(Character.valueOf(character));
                    expression = expression + character;
                    break;
                }
                case ')': {
                    if (state == 1) {
                        this.valueList.append(this.createValue(currentArg));
                        currentArg = "";
                    }
                    state = 0;
                    paren.pop();
                    expression = expression + character;
                    break;
                }
                case ',': {
                    if (state == 1) {
                        this.valueList.append(this.createValue(currentArg));
                        currentArg = "";
                    }
                    expression = expression + character;
                    break;
                }
                case '/': {
                    JSCommentStruct info = this._parseJSComment(token, idx);
                    if (info != null) {
                        if (info.error != 0) {
                            error = -2;
                            break;
                        }
                        idx = info.idx;
                        break;
                    }
                    expression = expression + character;
                    break;
                }
                case '\"': 
                case '\'': {
                    JSCommentStruct info = this._parseJSString(token, idx, character + "");
                    if (info != null) {
                        idx = info.idx;
                        expression = expression + info.text;
                        break;
                    }
                    expression = expression + character;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    switch (state) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            currentArg = currentArg + character;
                        }
                    }
                    expression = expression + character;
                }
            }
            if (error != 0 || paren.size() == 0) break;
            ++idx;
        }
        CSSValueExpressionInfo ret = new CSSValueExpressionInfo();
        ret.error = error;
        ret.idx = idx;
        ret.expression = expression;
        ret.cssValue = this.valueList;
        return ret;
    }

    private JSCommentStruct _parseJSComment(String token, int idx) {
        char nextChar = token.charAt(idx + 1);
        if (nextChar == '/' || nextChar == '*') {
            String commentEndChar = null;
            if (nextChar == '/') {
                commentEndChar = "\n";
            } else if (nextChar == '*') {
                commentEndChar = "*/";
            }
            JSCommentStruct struct = new JSCommentStruct();
            if (commentEndChar != null) {
                int startIdx = idx;
                int endIdx = token.indexOf(commentEndChar, startIdx + 1 + 1);
                if (endIdx != -1) {
                    endIdx = endIdx + commentEndChar.length() - 1;
                    String text = token.substring(idx, endIdx + 1);
                    struct.idx = endIdx;
                    struct.text = text;
                } else {
                    struct.error = -1;
                }
            } else {
                struct.error = -1;
            }
            return struct;
        }
        return null;
    }

    private JSCommentStruct _parseJSString(String token, int idx, String sep) {
        int endIdx = CSSValueParser._findMatchedIdx(token, idx, sep);
        if (endIdx == -1) {
            return null;
        }
        String text = token.substring(idx, endIdx + sep.length());
        JSCommentStruct struct = new JSCommentStruct();
        struct.idx = endIdx;
        struct.text = text;
        return struct;
    }

    private CSSValueList createArgumentContainer() {
        switch (this.type) {
            case 0: {
                return new CSSTransformValue(this.name);
            }
        }
        return new CSSValueList();
    }

    private CSSValue createValue(String value) {
        CSSPrimitiveValue val = null;
        switch (this.type) {
            default: 
        }
        val = new CSSPrimitiveValue(value);
        return val;
    }

    private static int _findMatchedIdx(String token, int idx, String sep) {
        int endIdx;
        int startIdx = idx;
        int NOT_FOUND = -1;
        RegExp result = new RegExp("\\+$", "");
        while (true) {
            if ((endIdx = token.indexOf(sep, startIdx + 1)) == -1) {
                endIdx = NOT_FOUND;
                break;
            }
            String text = token.substring(idx + 1, endIdx);
            RegExp.RegExpResult matched = result.exec(text);
            if (matched == null || matched.size() == 1) break;
            startIdx = endIdx;
        }
        int nextNewLineIdx = token.indexOf("\n", idx + 1);
        if (nextNewLineIdx < endIdx) {
            endIdx = NOT_FOUND;
        }
        return endIdx;
    }

    private class JSCommentStruct {
        int idx;
        String text;
        int error;

        private JSCommentStruct() {
        }
    }

    public class CSSValueExpressionInfo {
        public String expression;
        public int idx;
        public int error;
        public CSSValueList cssValue;
    }
}

